/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.namefind;

import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.featuregen.AdaptiveFeatureGenerator;
import chalk.tools.util.featuregen.FeatureGeneratorResourceProvider;
import chalk.tools.util.featuregen.GeneratorFactory;
import chalk.tools.util.model.ArtifactSerializer;
import chalk.tools.util.model.BaseModel;
import chalk.tools.util.model.ModelUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import nak.model.AbstractModel;
import nak.model.MaxentModel;

public class TokenNameFinderModel
extends BaseModel {
    private static final String COMPONENT_NAME = "NameFinderME";
    private static final String MAXENT_MODEL_ENTRY_NAME = "nameFinder.model";
    private static final String GENERATOR_DESCRIPTOR_ENTRY_NAME = "generator.featuregen";

    public TokenNameFinderModel(String string, AbstractModel abstractModel, byte[] byArray, Map<String, Object> map, Map<String, String> map2) {
        super(COMPONENT_NAME, string, map2);
        if (!TokenNameFinderModel.isModelValid((MaxentModel)abstractModel)) {
            throw new IllegalArgumentException("Model not compatible with name finder!");
        }
        this.artifactMap.put(MAXENT_MODEL_ENTRY_NAME, abstractModel);
        if (byArray != null && byArray.length > 0) {
            this.artifactMap.put(GENERATOR_DESCRIPTOR_ENTRY_NAME, byArray);
        }
        if (map != null) {
            if (map.containsKey(MAXENT_MODEL_ENTRY_NAME) || map.containsKey(GENERATOR_DESCRIPTOR_ENTRY_NAME)) {
                throw new IllegalArgumentException();
            }
            this.artifactMap.putAll(map);
        }
        this.checkArtifactMap();
    }

    public TokenNameFinderModel(String string, AbstractModel abstractModel, Map<String, Object> map, Map<String, String> map2) {
        this(string, abstractModel, null, map, map2);
    }

    public TokenNameFinderModel(InputStream inputStream) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, inputStream);
    }

    public TokenNameFinderModel(File file) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, file);
    }

    public TokenNameFinderModel(URL uRL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, uRL);
    }

    public AbstractModel getNameFinderModel() {
        return (AbstractModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
    }

    public AdaptiveFeatureGenerator createFeatureGenerators() {
        byte[] byArray = (byte[])this.artifactMap.get(GENERATOR_DESCRIPTOR_ENTRY_NAME);
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            AdaptiveFeatureGenerator adaptiveFeatureGenerator = null;
            try {
                adaptiveFeatureGenerator = GeneratorFactory.create(byteArrayInputStream, new FeatureGeneratorResourceProvider(){

                    @Override
                    public Object getResource(String string) {
                        return TokenNameFinderModel.this.artifactMap.get(string);
                    }
                });
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new FeatureGeneratorCreationError(invalidFormatException);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Reading from mem cannot result in an I/O error", iOException);
            }
            return adaptiveFeatureGenerator;
        }
        return null;
    }

    public TokenNameFinderModel updateFeatureGenerator(byte[] byArray) {
        TokenNameFinderModel tokenNameFinderModel = new TokenNameFinderModel(this.getLanguage(), this.getNameFinderModel(), byArray, Collections.<String, Object>emptyMap(), Collections.<String, String>emptyMap());
        tokenNameFinderModel.artifactMap.clear();
        tokenNameFinderModel.artifactMap.putAll(this.artifactMap);
        tokenNameFinderModel.artifactMap.put(GENERATOR_DESCRIPTOR_ENTRY_NAME, byArray);
        return tokenNameFinderModel;
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> map) {
        super.createArtifactSerializers(map);
        map.put("featuregen", new ByteArraySerializer());
    }

    public static Map<String, ArtifactSerializer> createArtifactSerializers() {
        Map<String, ArtifactSerializer> map = BaseModel.createArtifactSerializers();
        map.put("featuregen", new ByteArraySerializer());
        return map;
    }

    public static boolean isModelValid(MaxentModel maxentModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < maxentModel.getNumOutcomes(); ++i) {
            String string = maxentModel.getOutcome(i);
            if (string.endsWith("start")) {
                arrayList.add(string.substring(0, string.length() - "start".length()));
                continue;
            }
            if (string.endsWith("cont")) {
                arrayList2.add(string.substring(0, string.length() - "cont".length()));
                continue;
            }
            if (string.equals("other")) continue;
            return false;
        }
        if (arrayList.size() == 0) {
            return false;
        }
        for (String string : arrayList2) {
            if (arrayList.contains(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Token Name Finder model is incomplete!");
        }
        AbstractModel abstractModel = (AbstractModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
        TokenNameFinderModel.isModelValid((MaxentModel)abstractModel);
    }

    private static class ByteArraySerializer
    implements ArtifactSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        @Override
        public byte[] create(InputStream inputStream) throws IOException, InvalidFormatException {
            return ModelUtil.read(inputStream);
        }

        @Override
        public void serialize(byte[] byArray, OutputStream outputStream) throws IOException {
            outputStream.write(byArray);
        }
    }

    public static class FeatureGeneratorCreationError
    extends RuntimeException {
        FeatureGeneratorCreationError(Throwable throwable) {
            super(throwable);
        }
    }
}

