/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.parser;

import chalk.tools.chunker.Chunker;
import chalk.tools.dictionary.Dictionary;
import chalk.tools.ngram.NGramModel;
import chalk.tools.parser.HeadRules;
import chalk.tools.parser.Parse;
import chalk.tools.parser.Parser;
import chalk.tools.parser.chunking.ParserEventStream;
import chalk.tools.postag.POSTagger;
import chalk.tools.util.Heap;
import chalk.tools.util.ListHeap;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Sequence;
import chalk.tools.util.Span;
import chalk.tools.util.StringList;
import chalk.tools.util.TrainingParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

public abstract class AbstractBottomUpParser
implements Parser {
    protected int M;
    protected int K;
    protected double Q;
    public static final int defaultBeamSize = 20;
    public static final double defaultAdvancePercentage = 0.95;
    protected Heap<Parse> completeParses;
    protected Heap<Parse> odh;
    protected Heap<Parse> ndh;
    protected HeadRules headRules;
    protected Set<String> punctSet;
    public static final String TOP_NODE = "TOP";
    public static final String INC_NODE = "INC";
    public static final String TOK_NODE = "TK";
    public static final Integer ZERO = 0;
    public static final String START = "S-";
    public static final String CONT = "C-";
    public static final String OTHER = "O";
    public static final String COMPLETE = "c";
    public static final String INCOMPLETE = "i";
    protected POSTagger tagger;
    protected Chunker chunker;
    protected boolean reportFailedParse;
    protected boolean createDerivationString = false;
    protected boolean debugOn = false;

    public AbstractBottomUpParser(POSTagger pOSTagger, Chunker chunker, HeadRules headRules, int n, double d) {
        this.tagger = pOSTagger;
        this.chunker = chunker;
        this.M = n;
        this.K = n;
        this.Q = d;
        this.reportFailedParse = true;
        this.headRules = headRules;
        this.punctSet = headRules.getPunctuationTags();
        this.odh = new ListHeap<Parse>(this.K);
        this.ndh = new ListHeap<Parse>(this.K);
        this.completeParses = new ListHeap<Parse>(this.K);
    }

    public void setErrorReporting(boolean bl) {
        this.reportFailedParse = bl;
    }

    public static void setParents(Parse parse) {
        Parse[] parseArray = parse.getChildren();
        for (int i = 0; i < parseArray.length; ++i) {
            parseArray[i].setParent(parse);
            AbstractBottomUpParser.setParents(parseArray[i]);
        }
    }

    public static Parse[] collapsePunctuation(Parse[] parseArray, Set<String> set) {
        ArrayList<Parse> arrayList = new ArrayList<Parse>(parseArray.length);
        int n = -1;
        int n2 = -1;
        int n3 = parseArray.length;
        for (int i = 0; i < n3; ++i) {
            if (set.contains(parseArray[i].getType())) {
                if (n >= 0) {
                    parseArray[n].addNextPunctuation(parseArray[i]);
                }
                for (n2 = i + 1; n2 < n3 && set.contains(parseArray[n2].getType()); ++n2) {
                }
                if (n2 >= n3) continue;
                parseArray[n2].addPreviousPunctuation(parseArray[i]);
                continue;
            }
            arrayList.add(parseArray[i]);
            n = i;
        }
        if (arrayList.size() == parseArray.length) {
            return parseArray;
        }
        return arrayList.toArray(new Parse[arrayList.size()]);
    }

    protected abstract Parse[] advanceParses(Parse var1, double var2);

    protected abstract void advanceTop(Parse var1);

    @Override
    public Parse[] parse(Parse parse, int n) {
        Object object;
        if (this.createDerivationString) {
            parse.setDerivation(new StringBuffer(100));
        }
        this.odh.clear();
        this.ndh.clear();
        this.completeParses.clear();
        int n2 = 2 * parse.getChildCount() + 3;
        this.odh.add(parse);
        Parse parse2 = null;
        double d = 2.0;
        double d2 = -100000.0;
        for (int i = 0; this.odh.size() > 0 && (this.completeParses.size() < this.M || this.odh.first().getProb() < d) && i < n2; ++i) {
            this.ndh = new ListHeap<Parse>(this.K);
            object = this.odh.iterator();
            for (int j = 0; object.hasNext() && j < this.K; ++j) {
                Parse parse3 = (Parse)object.next();
                if (parse2 == null && i == 2) {
                    parse2 = parse3;
                }
                if (this.debugOn) {
                    System.out.print(i + " " + j + " " + parse3.getProb());
                    parse3.show();
                    System.out.println();
                }
                Parse[] parseArray = 0 == i ? this.advanceTags(parse3) : (1 == i ? (this.ndh.size() < this.K ? this.advanceChunks(parse3, d2) : this.advanceChunks(parse3, this.ndh.last().getProb())) : this.advanceParses(parse3, this.Q));
                if (parseArray != null) {
                    int n3 = parseArray.length;
                    for (int k = 0; k < n3; ++k) {
                        if (parseArray[k].complete()) {
                            this.advanceTop(parseArray[k]);
                            if (parseArray[k].getProb() > d2) {
                                d2 = parseArray[k].getProb();
                            }
                            if (parseArray[k].getProb() < d) {
                                d = parseArray[k].getProb();
                            }
                            this.completeParses.add(parseArray[k]);
                            continue;
                        }
                        this.ndh.add(parseArray[k]);
                    }
                    continue;
                }
                if (this.reportFailedParse) {
                    System.err.println("Couldn't advance parse " + i + " stage " + j + "!\n");
                }
                this.advanceTop(parse3);
                this.completeParses.add(parse3);
            }
            this.odh = this.ndh;
        }
        if (this.completeParses.size() == 0) {
            if (this.reportFailedParse) {
                System.err.println("Couldn't find parse for: " + parse);
            }
            return new Parse[]{parse2};
        }
        if (n == 1) {
            return new Parse[]{this.completeParses.first()};
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        while (!this.completeParses.isEmpty() && arrayList.size() < n) {
            object = this.completeParses.extract();
            arrayList.add(object);
        }
        return arrayList.toArray(new Parse[arrayList.size()]);
    }

    @Override
    public Parse parse(Parse parse) {
        if (parse.getChildCount() > 0) {
            Parse parse2 = this.parse(parse, 1)[0];
            AbstractBottomUpParser.setParents(parse2);
            return parse2;
        }
        return parse;
    }

    protected Parse[] advanceChunks(Parse parse, double d) {
        Parse[] parseArray = parse.getChildren();
        String[] stringArray = new String[parseArray.length];
        String[] stringArray2 = new String[stringArray.length];
        double[] dArray = new double[stringArray.length];
        Parse parse22 = null;
        for (Parse parse22 : parseArray) {
            stringArray[var9_8] = parse22.getHead().getCoveredText();
            stringArray2[var9_8] = parse22.getType();
        }
        Sequence[] sequenceArray = this.chunker.topKSequences(stringArray, stringArray2, d - parse.getProb());
        Parse[] parseArray2 = new Parse[sequenceArray.length];
        int n = sequenceArray.length;
        for (int i = 0; i < n; ++i) {
            parseArray2[i] = (Parse)parse.clone();
            if (this.createDerivationString) {
                parseArray2[i].getDerivation().append(i).append(".");
            }
            String[] stringArray3 = sequenceArray[i].getOutcomes().toArray(new String[stringArray.length]);
            sequenceArray[i].getProbs(dArray);
            int n2 = -1;
            int n3 = 0;
            String string = null;
            for (int j = 0; j <= stringArray3.length; ++j) {
                if (j != stringArray3.length) {
                    parseArray2[i].addProb(Math.log(dArray[j]));
                }
                if (j != stringArray3.length && stringArray3[j].startsWith(CONT)) {
                    n3 = j;
                    continue;
                }
                if (string != null) {
                    Parse parse3 = parse.getChildren()[n2];
                    Parse parse4 = parse.getChildren()[n3];
                    Parse[] parseArray3 = new Parse[n3 - n2 + 1];
                    parseArray3[0] = parse3;
                    if (n3 - n2 != 0) {
                        parseArray3[n3 - n2] = parse4;
                        for (int k = 1; k < n3 - n2; ++k) {
                            parseArray3[k] = parse.getChildren()[k + n2];
                        }
                    }
                    Parse parse5 = new Parse(parse3.getText(), new Span(parse3.getSpan().getStart(), parse4.getSpan().getEnd()), string, 1.0, this.headRules.getHead(parseArray3, string));
                    parse5.isChunk(true);
                    parseArray2[i].insert(parse5);
                }
                if (j == stringArray3.length) continue;
                if (stringArray3[j].startsWith(START)) {
                    string = stringArray3[j].substring(START.length());
                    n2 = j;
                    n3 = j;
                    continue;
                }
                string = null;
            }
        }
        return parseArray2;
    }

    protected Parse[] advanceTags(Parse parse) {
        Parse[] parseArray = parse.getChildren();
        String[] stringArray = new String[parseArray.length];
        double[] dArray = new double[stringArray.length];
        int n = parseArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = parseArray[i].getCoveredText();
        }
        Sequence[] sequenceArray = this.tagger.topKSequences(stringArray);
        if (sequenceArray.length == 0) {
            System.err.println("no tag sequence");
        }
        Parse[] parseArray2 = new Parse[sequenceArray.length];
        for (int i = 0; i < sequenceArray.length; ++i) {
            String[] stringArray2 = sequenceArray[i].getOutcomes().toArray(new String[stringArray.length]);
            sequenceArray[i].getProbs(dArray);
            parseArray2[i] = (Parse)parse.clone();
            if (this.createDerivationString) {
                parseArray2[i].getDerivation().append(i).append(".");
            }
            for (int j = 0; j < stringArray.length; ++j) {
                Parse parse2 = parseArray[j];
                double d = dArray[j];
                parseArray2[i].insert(new Parse(parse2.getText(), parse2.getSpan(), stringArray2[j], d, j));
                parseArray2[i].addProb(Math.log(d));
            }
        }
        return parseArray2;
    }

    protected int mapParseIndex(int n, Parse[] parseArray, Parse[] parseArray2) {
        int n2 = n;
        while (parseArray2[n2] != parseArray[n]) {
            ++n2;
        }
        return n2;
    }

    private static boolean lastChild(Parse parse, Parse parse2, Set<String> set) {
        Parse[] parseArray = AbstractBottomUpParser.collapsePunctuation(parse2.getChildren(), set);
        return parseArray[parseArray.length - 1] == parse;
    }

    public static Dictionary buildDictionary(ObjectStream<Parse> objectStream, HeadRules headRules, TrainingParameters trainingParameters) throws IOException {
        Parse parse;
        int n = 5;
        String string = trainingParameters.getSettings("dict").get("Cutoff");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        NGramModel nGramModel = new NGramModel();
        while ((parse = objectStream.read()) != null) {
            int n2;
            parse.updateHeads(headRules);
            Parse[] parseArray = parse.getTagNodes();
            String[] stringArray = new String[parseArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = parseArray[i].getCoveredText();
            }
            nGramModel.add(new StringList(stringArray), 1, 1);
            Parse[] parseArray2 = AbstractBottomUpParser.collapsePunctuation(ParserEventStream.getInitialChunks(parse), headRules.getPunctuationTags());
            String[] stringArray2 = new String[parseArray2.length];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                stringArray2[n2] = parseArray2[n2].getHead().getCoveredText();
            }
            nGramModel.add(new StringList(stringArray2), 2, 3);
            for (n2 = 0; n2 < parseArray2.length; ++n2) {
                int n3;
                if (!AbstractBottomUpParser.lastChild(parseArray2[n2], parseArray2[n2].getParent(), headRules.getPunctuationTags())) continue;
                for (n3 = n2; n3 >= 0 && parseArray2[n3].getParent() == parseArray2[n2].getParent(); --n3) {
                }
                parseArray2 = ParserEventStream.reduceChunks(parseArray2, n2, parseArray2[n2].getParent());
                n2 = ++n3;
                if (parseArray2.length != 0) {
                    String[] stringArray3 = new String[5];
                    int n4 = 0;
                    if (n2 - 2 >= 0) {
                        stringArray3[n4++] = parseArray2[n2 - 2].getHead().getCoveredText();
                    }
                    if (n2 - 1 >= 0) {
                        stringArray3[n4++] = parseArray2[n2 - 1].getHead().getCoveredText();
                    }
                    stringArray3[n4++] = parseArray2[n2].getHead().getCoveredText();
                    if (n2 + 1 < parseArray2.length) {
                        stringArray3[n4++] = parseArray2[n2 + 1].getHead().getCoveredText();
                    }
                    if (n2 + 2 < parseArray2.length) {
                        stringArray3[n4++] = parseArray2[n2 + 2].getHead().getCoveredText();
                    }
                    if (n4 < 5) {
                        String[] stringArray4 = new String[n4];
                        for (int i = 0; i < n4; ++i) {
                            stringArray4[i] = stringArray3[i];
                        }
                        stringArray3 = stringArray4;
                    }
                    if (stringArray3.length >= 3) {
                        nGramModel.add(new StringList(stringArray3), 2, 3);
                    } else if (stringArray3.length == 2) {
                        nGramModel.add(new StringList(stringArray3), 2, 2);
                    }
                }
                n2 = n3 - 1;
            }
        }
        nGramModel.cutoff(n, Integer.MAX_VALUE);
        return nGramModel.toDictionary(true);
    }

    public static Dictionary buildDictionary(ObjectStream<Parse> objectStream, HeadRules headRules, int n) throws IOException {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("dict", "Cutoff", Integer.toString(n));
        return AbstractBottomUpParser.buildDictionary(objectStream, headRules, trainingParameters);
    }
}

