/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.parser;

import chalk.tools.chunker.ChunkerContextGenerator;
import chalk.tools.dictionary.Dictionary;
import chalk.tools.parser.AbstractBottomUpParser;
import chalk.tools.parser.ChunkContextGenerator;
import chalk.tools.parser.HeadRules;
import chalk.tools.parser.Parse;
import chalk.tools.parser.ParserEventTypeEnum;
import chalk.tools.parser.chunking.Parser;
import chalk.tools.postag.DefaultPOSContextGenerator;
import chalk.tools.postag.POSContextGenerator;
import chalk.tools.util.AbstractEventStream;
import chalk.tools.util.ObjectStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nak.model.Event;

public abstract class AbstractParserEventStream
extends AbstractEventStream<Parse> {
    private ChunkerContextGenerator chunkerContextGenerator;
    private POSContextGenerator tagContextGenerator;
    protected HeadRules rules;
    protected Set<String> punctSet;
    protected ParserEventTypeEnum etype;
    protected boolean fixPossesives;
    protected Dictionary dict;

    public AbstractParserEventStream(ObjectStream<Parse> objectStream, HeadRules headRules, ParserEventTypeEnum parserEventTypeEnum, Dictionary dictionary) {
        super(objectStream);
        this.dict = dictionary;
        if (parserEventTypeEnum == ParserEventTypeEnum.CHUNK) {
            this.chunkerContextGenerator = new ChunkContextGenerator();
        } else if (parserEventTypeEnum == ParserEventTypeEnum.TAG) {
            this.tagContextGenerator = new DefaultPOSContextGenerator(null);
        }
        this.rules = headRules;
        this.punctSet = headRules.getPunctuationTags();
        this.etype = parserEventTypeEnum;
        this.init();
    }

    @Override
    protected Iterator<Event> createEvents(Parse parse) {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        Parse.pruneParse(parse);
        if (this.fixPossesives) {
            Parse.fixPossesives(parse);
        }
        parse.updateHeads(this.rules);
        Parse[] parseArray = AbstractParserEventStream.getInitialChunks(parse);
        if (this.etype == ParserEventTypeEnum.TAG) {
            this.addTagEvents(arrayList, parseArray);
        } else if (this.etype == ParserEventTypeEnum.CHUNK) {
            this.addChunkEvents(arrayList, parseArray);
        } else {
            this.addParseEvents(arrayList, Parser.collapsePunctuation(parseArray, this.punctSet));
        }
        return arrayList.iterator();
    }

    protected void init() {
        this.fixPossesives = false;
    }

    public AbstractParserEventStream(ObjectStream<Parse> objectStream, HeadRules headRules, ParserEventTypeEnum parserEventTypeEnum) {
        this(objectStream, headRules, parserEventTypeEnum, null);
    }

    public static Parse[] getInitialChunks(Parse parse) {
        ArrayList<Parse> arrayList = new ArrayList<Parse>();
        AbstractParserEventStream.getInitialChunks(parse, arrayList);
        return arrayList.toArray(new Parse[arrayList.size()]);
    }

    private static void getInitialChunks(Parse parse, List<Parse> list) {
        if (parse.isPosTag()) {
            list.add(parse);
        } else {
            int n;
            Parse[] parseArray = parse.getChildren();
            boolean bl = true;
            int n2 = parseArray.length;
            for (n = 0; n < n2; ++n) {
                if (parseArray[n].isPosTag()) continue;
                bl = false;
                break;
            }
            if (bl) {
                list.add(parse);
            } else {
                n2 = parseArray.length;
                for (n = 0; n < n2; ++n) {
                    AbstractParserEventStream.getInitialChunks(parseArray[n], list);
                }
            }
        }
    }

    protected abstract void addParseEvents(List<Event> var1, Parse[] var2);

    private void addChunkEvents(List<Event> list, Parse[] parseArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (Parse parse : parseArray) {
            if (parse.isPosTag()) {
                arrayList.add(parse.getCoveredText());
                arrayList2.add(parse.getType());
                arrayList3.add("O");
                continue;
            }
            boolean bl = true;
            String string = parse.getType();
            for (Parse parse2 : parse.getChildren()) {
                arrayList.add(parse2.getCoveredText());
                arrayList2.add(parse2.getType());
                if (bl) {
                    arrayList3.add("S-" + string);
                    bl = false;
                    continue;
                }
                arrayList3.add("C-" + string);
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            list.add(new Event((String)arrayList3.get(i), this.chunkerContextGenerator.getContext(i, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), arrayList3.toArray(new String[arrayList3.size()]))));
        }
    }

    private void addTagEvents(List<Event> list, Parse[] parseArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Parse parse : parseArray) {
            if (parse.isPosTag()) {
                arrayList.add(parse.getCoveredText());
                arrayList2.add(parse.getType());
                continue;
            }
            for (Parse parse2 : parse.getChildren()) {
                arrayList.add(parse2.getCoveredText());
                arrayList2.add(parse2.getType());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            list.add(new Event((String)arrayList2.get(i), this.tagContextGenerator.getContext(i, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), (Object[])null)));
        }
    }

    protected boolean lastChild(Parse parse, Parse parse2) {
        Parse[] parseArray = AbstractBottomUpParser.collapsePunctuation(parse2.getChildren(), this.punctSet);
        return parseArray[parseArray.length - 1] == parse;
    }
}

