/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.parser;

import chalk.tools.parser.Constituent;
import chalk.tools.parser.GapLabeler;
import chalk.tools.parser.lang.en.HeadRules;
import chalk.tools.util.Span;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parse
implements Cloneable,
Comparable<Parse> {
    public static final String BRACKET_LRB = "(";
    public static final String BRACKET_RRB = ")";
    public static final String BRACKET_LCB = "{";
    public static final String BRACKET_RCB = "}";
    private String text;
    private Span span;
    private String type;
    private List<Parse> parts;
    private Parse head;
    private String label;
    private int headIndex;
    private Parse parent;
    private double prob;
    private StringBuffer derivation;
    private boolean isChunk;
    private static Pattern typePattern = Pattern.compile("^([^ =-]+)");
    private static Pattern funTypePattern = Pattern.compile("^[^ =-]+-([^ =-]+)");
    private static Pattern tokenPattern = Pattern.compile("^[^ ()]+ ([^ ()]+)\\s*\\)");
    private Collection<Parse> prevPunctSet;
    private Collection<Parse> nextPunctSet;
    private static boolean useFunctionTags;

    public Parse(String string, Span span, String string2, double d, int n) {
        this.text = string;
        this.span = span;
        this.type = string2;
        this.prob = d;
        this.head = this;
        this.headIndex = n;
        this.parts = new LinkedList<Parse>();
        this.label = null;
        this.parent = null;
    }

    public Parse(String string, Span span, String string2, double d, Parse parse) {
        this(string, span, string2, d, 0);
        if (parse != null) {
            this.head = parse;
            this.headIndex = parse.headIndex;
        }
    }

    public Object clone() {
        Parse parse = new Parse(this.text, this.span, this.type, this.prob, this.head);
        parse.parts = new LinkedList<Parse>();
        parse.parts.addAll(this.parts);
        if (this.derivation != null) {
            parse.derivation = new StringBuffer(100);
            parse.derivation.append(this.derivation.toString());
        }
        parse.label = this.label;
        return parse;
    }

    public Parse clone(Parse parse) {
        if (this == parse) {
            return (Parse)this.clone();
        }
        Parse parse2 = (Parse)this.clone();
        Parse parse3 = parse2.parts.get(this.parts.size() - 1);
        parse2.parts.set(this.parts.size() - 1, parse3.clone(parse));
        return parse2;
    }

    public Parse cloneRoot(Parse parse, int n) {
        Parse parse2 = (Parse)this.clone();
        Parse parse3 = parse2.parts.get(n);
        parse2.parts.set(n, parse3.clone(parse));
        return parse2;
    }

    public static void useFunctionTags(boolean bl) {
        useFunctionTags = bl;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public Collection<Parse> getPreviousPunctuationSet() {
        return this.prevPunctSet;
    }

    public void addPreviousPunctuation(Parse parse) {
        if (this.prevPunctSet == null) {
            this.prevPunctSet = new TreeSet<Parse>();
        }
        this.prevPunctSet.add(parse);
    }

    public Collection<Parse> getNextPunctuationSet() {
        return this.nextPunctSet;
    }

    public void addNextPunctuation(Parse parse) {
        if (this.nextPunctSet == null) {
            this.nextPunctSet = new TreeSet<Parse>();
        }
        this.nextPunctSet.add(parse);
    }

    public void setNextPunctuation(Collection<Parse> collection) {
        this.nextPunctSet = collection;
    }

    public void setPrevPunctuation(Collection<Parse> collection) {
        this.prevPunctSet = collection;
    }

    public void insert(Parse parse) {
        int n;
        Span span = parse.span;
        if (this.span.contains(span)) {
            int n2 = this.parts.size();
            for (n = 0; n < n2; ++n) {
                Parse parse2 = this.parts.get(n);
                Span span2 = parse2.span;
                if (span2.getStart() >= span.getEnd()) break;
                if (span.contains(span2)) {
                    this.parts.remove(n);
                    --n;
                    parse.parts.add(parse2);
                    parse2.setParent(parse);
                    n2 = this.parts.size();
                    continue;
                }
                if (!span2.contains(span)) continue;
                parse2.insert(parse);
                return;
            }
        } else {
            throw new IllegalArgumentException("Inserting constituent not contained in the sentence!");
        }
        this.parts.add(n, parse);
        parse.setParent(this);
    }

    public void show(StringBuffer stringBuffer) {
        int n = this.span.getStart();
        if (!this.type.equals("TK")) {
            stringBuffer.append(BRACKET_LRB);
            stringBuffer.append(this.type).append(" ");
        }
        for (Parse parse : this.parts) {
            Span span = parse.span;
            if (n < span.getStart()) {
                stringBuffer.append(Parse.encodeToken(this.text.substring(n, span.getStart())));
            }
            parse.show(stringBuffer);
            n = span.getEnd();
        }
        if (n < this.span.getEnd()) {
            stringBuffer.append(Parse.encodeToken(this.text.substring(n, this.span.getEnd())));
        }
        if (!this.type.equals("TK")) {
            stringBuffer.append(BRACKET_RRB);
        }
    }

    public void show() {
        StringBuffer stringBuffer = new StringBuffer(this.text.length() * 4);
        this.show(stringBuffer);
        System.out.println(stringBuffer);
    }

    public double getTagSequenceProb() {
        if (this.parts.size() == 1 && this.parts.get((int)0).type.equals("TK")) {
            return Math.log(this.prob);
        }
        if (this.parts.size() == 0) {
            System.err.println("Parse.getTagSequenceProb: Wrong base case!");
            return 0.0;
        }
        double d = 0.0;
        Iterator<Parse> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            d += iterator.next().getTagSequenceProb();
        }
        return d;
    }

    public boolean complete() {
        return this.parts.size() == 1;
    }

    public String getCoveredText() {
        return this.text.substring(this.span.getStart(), this.span.getEnd());
    }

    public String toString() {
        return this.getCoveredText();
    }

    public String getText() {
        return this.text;
    }

    public Span getSpan() {
        return this.span;
    }

    public double getProb() {
        return this.prob;
    }

    public void addProb(double d) {
        this.prob += d;
    }

    public Parse[] getChildren() {
        return this.parts.toArray(new Parse[this.parts.size()]);
    }

    public void setChild(int n, String string) {
        Parse parse = (Parse)this.parts.get(n).clone();
        parse.setLabel(string);
        this.parts.set(n, parse);
    }

    public void add(Parse parse, chalk.tools.parser.HeadRules headRules) {
        if (parse.prevPunctSet != null) {
            this.parts.addAll(parse.prevPunctSet);
        }
        this.parts.add(parse);
        this.span = new Span(this.span.getStart(), parse.getSpan().getEnd());
        this.head = headRules.getHead(this.getChildren(), this.type);
        if (this.head == null) {
            System.err.println(this.parts);
        }
        this.headIndex = this.head.headIndex;
    }

    public void remove(int n) {
        this.parts.remove(n);
        if (n == 0 || n == this.parts.size()) {
            this.span = new Span(this.parts.get((int)0).span.getStart(), this.parts.get((int)(this.parts.size() - 1)).span.getEnd());
        }
    }

    public Parse adjoinRoot(Parse parse, chalk.tools.parser.HeadRules headRules, int n) {
        Parse parse2 = this.parts.get(n);
        Parse parse3 = new Parse(this.text, new Span(parse2.getSpan().getStart(), parse.getSpan().getEnd()), parse2.getType(), 1.0, headRules.getHead(new Parse[]{parse2, parse}, parse2.getType()));
        parse3.parts.add(parse2);
        if (parse.prevPunctSet != null) {
            parse3.parts.addAll(parse.prevPunctSet);
        }
        parse3.parts.add(parse);
        this.parts.set(n, parse3);
        return parse3;
    }

    public Parse adjoin(Parse parse, chalk.tools.parser.HeadRules headRules) {
        Parse parse2 = this.parts.get(this.parts.size() - 1);
        Parse parse3 = new Parse(this.text, new Span(parse2.getSpan().getStart(), parse.getSpan().getEnd()), parse2.getType(), 1.0, headRules.getHead(new Parse[]{parse2, parse}, parse2.getType()));
        parse3.parts.add(parse2);
        if (parse.prevPunctSet != null) {
            parse3.parts.addAll(parse.prevPunctSet);
        }
        parse3.parts.add(parse);
        this.parts.set(this.parts.size() - 1, parse3);
        this.span = new Span(this.span.getStart(), parse.getSpan().getEnd());
        this.head = headRules.getHead(this.getChildren(), this.type);
        this.headIndex = this.head.headIndex;
        return parse3;
    }

    public void expandTopNode(Parse parse) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n < this.parts.size()) {
            Parse parse2 = this.parts.get(n);
            if (parse2 == parse) {
                bl = false;
            } else if (bl) {
                parse.parts.add(n2, parse2);
                this.parts.remove(n);
                --n;
            } else {
                parse.parts.add(parse2);
                this.parts.remove(n);
                --n;
            }
            ++n;
            ++n2;
        }
        parse.updateSpan();
    }

    public int getChildCount() {
        return this.parts.size();
    }

    public int indexOf(Parse parse) {
        return this.parts.indexOf(parse);
    }

    public Parse getHead() {
        return this.head;
    }

    public int getHeadIndex() {
        return this.headIndex;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    private static String getType(String string) {
        if (string.startsWith("-LCB-")) {
            return "-LCB-";
        }
        if (string.startsWith("-RCB-")) {
            return "-RCB-";
        }
        if (string.startsWith("-LRB-")) {
            return "-LRB-";
        }
        if (string.startsWith("-RRB-")) {
            return "-RRB-";
        }
        if (string.startsWith("-NONE-")) {
            return "-NONE-";
        }
        Matcher matcher = typePattern.matcher(string);
        if (matcher.find()) {
            Matcher matcher2;
            String string2 = matcher.group(1);
            if (useFunctionTags && (matcher2 = funTypePattern.matcher(string)).find()) {
                String string3 = matcher2.group(1);
                string2 = string2 + "-" + string3;
            }
            return string2;
        }
        return null;
    }

    private static String encodeToken(String string) {
        if (BRACKET_LRB.equals(string)) {
            return "-LRB-";
        }
        if (BRACKET_RRB.equals(string)) {
            return "-RRB-";
        }
        if (BRACKET_LCB.equals(string)) {
            return "-LCB-";
        }
        if (BRACKET_RCB.equals(string)) {
            return "-RCB-";
        }
        return string;
    }

    private static String decodeToken(String string) {
        if ("-LRB-".equals(string)) {
            return BRACKET_LRB;
        }
        if ("-RRB-".equals(string)) {
            return BRACKET_RRB;
        }
        if ("-LCB-".equals(string)) {
            return BRACKET_LCB;
        }
        if ("-RCB-".equals(string)) {
            return BRACKET_RCB;
        }
        return string;
    }

    private static String getToken(String string) {
        Matcher matcher = tokenPattern.matcher(string);
        if (matcher.find()) {
            return Parse.decodeToken(matcher.group(1));
        }
        return null;
    }

    public void updateHeads(chalk.tools.parser.HeadRules headRules) {
        if (this.parts != null && this.parts.size() != 0) {
            int n = this.parts.size();
            for (int i = 0; i < n; ++i) {
                Parse parse = this.parts.get(i);
                parse.updateHeads(headRules);
            }
            this.head = headRules.getHead(this.parts.toArray(new Parse[this.parts.size()]), this.type);
            if (this.head == null) {
                this.head = this;
            } else {
                this.headIndex = this.head.headIndex;
            }
        } else {
            this.head = this;
        }
    }

    public void updateSpan() {
        this.span = new Span(this.parts.get((int)0).span.getStart(), this.parts.get((int)(this.parts.size() - 1)).span.getEnd());
    }

    public static void pruneParse(Parse parse) {
        LinkedList<Parse> linkedList = new LinkedList<Parse>();
        linkedList.add(parse);
        while (linkedList.size() != 0) {
            Parse parse2 = (Parse)linkedList.remove(0);
            Parse[] parseArray = parse2.getChildren();
            if (parseArray.length == 1 && parse2.getType().equals(parseArray[0].getType())) {
                int n = parse2.getParent().parts.indexOf(parse2);
                parseArray[0].setParent(parse2.getParent());
                parse2.getParent().parts.set(n, parseArray[0]);
                parse2.parent = null;
                parse2.parts = null;
            }
            linkedList.addAll(Arrays.asList(parseArray));
        }
    }

    public static void fixPossesives(Parse parse) {
        Parse[] parseArray = parse.getTagNodes();
        for (int i = 0; i < parseArray.length; ++i) {
            if (!parseArray[i].getType().equals("POS") || i + 1 >= parseArray.length || parseArray[i + 1].getParent() != parseArray[i].getParent().getParent()) continue;
            int n = parseArray[i + 1].getSpan().getStart();
            int n2 = parseArray[i + 1].getSpan().getEnd();
            for (int j = i + 2; j < parseArray.length && parseArray[j].getParent() == parseArray[j - 1].getParent(); ++j) {
                n2 = parseArray[j].getSpan().getEnd();
            }
            Parse parse2 = new Parse(parse.getText(), new Span(n, n2), "NP", 1.0, parseArray[i + 1]);
            parse.insert(parse2);
        }
    }

    public static Parse parseParse(String string) {
        return Parse.parseParse(string, null);
    }

    public static Parse parseParse(String string, GapLabeler gapLabeler) {
        String string2;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Stack<Constituent> stack = new Stack<Constituent>();
        LinkedList<Constituent> linkedList = new LinkedList<Constituent>();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3;
            Object object2;
            char c = string.charAt(i);
            if (c == '(') {
                object2 = string.substring(i + 1);
                object = Parse.getType((String)object2);
                if (object == null) {
                    System.err.println("null type for: " + (String)object2);
                }
                string2 = Parse.getToken((String)object2);
                stack.push(new Constituent((String)object, new Span(n, n)));
                if (string2 == null) continue;
                if (((String)object).equals("-NONE-") && gapLabeler != null) {
                    gapLabeler.labelGaps(stack);
                    continue;
                }
                linkedList.add(new Constituent("TK", new Span(n, n + string2.length())));
                stringBuilder.append(string2).append(" ");
                n += string2.length() + 1;
                continue;
            }
            if (c != ')' || (n3 = ((Constituent)(object2 = (Constituent)stack.pop())).getSpan().getStart()) >= n) continue;
            linkedList.add(new Constituent(((Constituent)object2).getLabel(), new Span(n3, n - 1)));
        }
        String string3 = stringBuilder.toString();
        n2 = -1;
        Parse parse = new Parse(string3, new Span(0, string3.length()), "TOP", 1.0, 0);
        for (int i = 0; i < linkedList.size(); ++i) {
            object = (Constituent)linkedList.get(i);
            string2 = ((Constituent)object).getLabel();
            if (string2.equals("TOP")) continue;
            if (string2 == "TK") {
                ++n2;
            }
            Parse parse2 = new Parse(string3, ((Constituent)object).getSpan(), string2, 1.0, n2);
            parse.insert(parse2);
        }
        return parse;
    }

    public Parse getParent() {
        return this.parent;
    }

    public void setParent(Parse parse) {
        this.parent = parse;
    }

    public boolean isPosTag() {
        return this.parts.size() == 1 && this.parts.get(0).getType().equals("TK");
    }

    public boolean isFlat() {
        boolean bl = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            bl &= this.parts.get(i).isPosTag();
        }
        return bl;
    }

    public void isChunk(boolean bl) {
        this.isChunk = bl;
    }

    public boolean isChunk() {
        return this.isChunk;
    }

    public Parse[] getTagNodes() {
        LinkedList<Parse> linkedList = new LinkedList<Parse>();
        LinkedList<Parse> linkedList2 = new LinkedList<Parse>();
        linkedList2.addAll(this.parts);
        while (linkedList2.size() != 0) {
            Parse parse = (Parse)linkedList2.remove(0);
            if (parse.isPosTag()) {
                linkedList.add(parse);
                continue;
            }
            linkedList2.addAll(0, parse.parts);
        }
        return linkedList.toArray(new Parse[linkedList.size()]);
    }

    public Parse getCommonParent(Parse parse) {
        if (this == parse) {
            return this.parent;
        }
        HashSet<Parse> hashSet = new HashSet<Parse>();
        for (Parse parse2 = this; parse2 != null; parse2 = parse2.getParent()) {
            hashSet.add(parse2);
        }
        while (parse != null) {
            if (hashSet.contains(parse)) {
                return parse;
            }
            parse = parse.getParent();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof Parse) {
            Parse parse = (Parse)object;
            if (this.label == null ? parse.label != null : !this.label.equals(parse.label)) {
                return false;
            }
            if (!this.span.equals(parse.span)) {
                return false;
            }
            if (!this.text.equals(parse.text)) {
                return false;
            }
            if (this.parts.size() != parse.parts.size()) {
                return false;
            }
            for (int i = 0; i < this.parts.size(); ++i) {
                if (this.parts.get(i).equals(parse.parts.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.span.hashCode();
        n = 37 * n + this.text.hashCode();
        return n;
    }

    @Override
    public int compareTo(Parse parse) {
        if (this.getProb() > parse.getProb()) {
            return -1;
        }
        if (this.getProb() < parse.getProb()) {
            return 1;
        }
        return 0;
    }

    public StringBuffer getDerivation() {
        return this.derivation;
    }

    public void setDerivation(StringBuffer stringBuffer) {
        this.derivation = stringBuffer;
    }

    private void codeTree(Parse parse, int[] nArray) {
        int n;
        Parse[] parseArray = parse.getChildren();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int[] nArray2 = new int[nArray.length + 1];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = nArray[n];
            stringBuilder.append(nArray[n]).append(".");
        }
        for (n = 0; n < parseArray.length; ++n) {
            nArray2[nArray.length] = n;
            System.out.println(stringBuilder.toString() + n + "] " + parseArray[n].getType() + " " + parseArray[n].hashCode() + " -> " + parseArray[n].getParent().hashCode() + " " + parseArray[n].getParent().getType() + " " + parseArray[n].getCoveredText());
            this.codeTree(parseArray[n], nArray2);
        }
    }

    public void showCodeTree() {
        this.codeTree(this, new int[0]);
    }

    public static void addNames(String string, Span[] spanArray, Parse[] parseArray) {
        for (Span span : spanArray) {
            Parse[] parseArray2;
            Parse parse;
            Parse parse2 = parseArray[span.getStart()];
            Parse parse3 = parse2.getCommonParent(parse = parseArray[span.getEnd() - 1]);
            if (parse3 == null) continue;
            Span span2 = new Span(parse2.getSpan().getStart(), parse.getSpan().getEnd());
            if (span2.equals(parse3.getSpan())) {
                parse3.insert(new Parse(parse3.getText(), span2, string, 1.0, parse.getHeadIndex()));
                continue;
            }
            Parse[] parseArray3 = parse3.getChildren();
            boolean bl = false;
            int n = parseArray3.length;
            for (int i = 0; i < n; ++i) {
                if (!span2.crosses(parseArray3[i].getSpan())) continue;
                bl = true;
            }
            if (!bl) {
                parse3.insert(new Parse(parse3.getText(), span2, string, 1.0, parse.getHeadIndex()));
                continue;
            }
            if (!parse3.getType().equals("NP") || (parseArray2 = parseArray3[0].getChildren()).length <= 1 || !span2.contains(parseArray2[parseArray2.length - 1].getSpan())) continue;
            parse3.insert(new Parse(parse3.getText(), parse3.getSpan(), string, 1.0, parse3.getHeadIndex()));
        }
    }

    @Deprecated
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: Parse -fun -pos head_rules < train_parses");
            System.err.println("Reads training parses (one-sentence-per-line) and displays parse structure.");
            System.exit(1);
        }
        int n = 0;
        boolean bl = false;
        while (stringArray[n].startsWith("-") && n < stringArray.length) {
            if (stringArray[n].equals("-fun")) {
                Parse.useFunctionTags(true);
                ++n;
                continue;
            }
            if (!stringArray[n].equals("-pos")) continue;
            bl = true;
            ++n;
        }
        HeadRules headRules = new HeadRules(stringArray[n]);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = bufferedReader.readLine();
        while (string != null) {
            Parse parse = Parse.parseParse(string, headRules);
            Parse.pruneParse(parse);
            if (bl) {
                Parse.fixPossesives(parse);
            }
            parse.updateHeads(headRules);
            parse.show();
            string = bufferedReader.readLine();
        }
    }
}

