/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.parser;

import chalk.tools.chunker.ChunkerModel;
import chalk.tools.util.SequenceValidator;
import java.util.HashMap;
import java.util.Map;

public class ParserChunkerSequenceValidator
implements SequenceValidator<String> {
    private Map<String, String> continueStartMap;

    public ParserChunkerSequenceValidator(ChunkerModel chunkerModel) {
        this.continueStartMap = new HashMap<String, String>(chunkerModel.getChunkerModel().getNumOutcomes());
        int n = chunkerModel.getChunkerModel().getNumOutcomes();
        for (int i = 0; i < n; ++i) {
            String string = chunkerModel.getChunkerModel().getOutcome(i);
            if (!string.startsWith("C-")) continue;
            this.continueStartMap.put(string, "S-" + string.substring("C-".length()));
        }
    }

    public boolean validSequence(int n, String[] stringArray, String[] stringArray2, String string) {
        if (this.continueStartMap.containsKey(string)) {
            int n2 = stringArray2.length - 1;
            if (n2 == -1) {
                return false;
            }
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            if (string2.equals(this.continueStartMap.get(string))) {
                return true;
            }
            if (string2.equals("O")) {
                return false;
            }
            return false;
        }
        return true;
    }
}

