/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.parser;

import chalk.tools.chunker.ChunkerModel;
import chalk.tools.parser.ParserType;
import chalk.tools.parser.lang.en.HeadRules;
import chalk.tools.postag.POSModel;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.model.ArtifactSerializer;
import chalk.tools.util.model.BaseModel;
import chalk.tools.util.model.UncloseableInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Map;
import nak.model.AbstractModel;

public class ParserModel
extends BaseModel {
    private static final String COMPONENT_NAME = "Parser";
    private static final String BUILD_MODEL_ENTRY_NAME = "build.model";
    private static final String CHECK_MODEL_ENTRY_NAME = "check.model";
    private static final String ATTACH_MODEL_ENTRY_NAME = "attach.model";
    private static final String PARSER_TAGGER_MODEL_ENTRY_NAME = "parsertager.postagger";
    private static final String CHUNKER_TAGGER_MODEL_ENTRY_NAME = "parserchunker.chunker";
    private static final String HEAD_RULES_MODEL_ENTRY_NAME = "head-rules.headrules";
    private static final String PARSER_TYPE = "parser-type";

    public ParserModel(String string, AbstractModel abstractModel, AbstractModel abstractModel2, AbstractModel abstractModel3, POSModel pOSModel, ChunkerModel chunkerModel, HeadRules headRules, ParserType parserType, Map<String, String> map) {
        super(COMPONENT_NAME, string, map);
        this.setManifestProperty(PARSER_TYPE, parserType.name());
        this.artifactMap.put(BUILD_MODEL_ENTRY_NAME, abstractModel);
        this.artifactMap.put(CHECK_MODEL_ENTRY_NAME, abstractModel2);
        if (ParserType.CHUNKING.equals((Object)parserType)) {
            if (abstractModel3 != null) {
                throw new IllegalArgumentException("attachModel must be null for chunking parser!");
            }
        } else if (ParserType.TREEINSERT.equals((Object)parserType)) {
            if (abstractModel3 == null) {
                throw new IllegalArgumentException("attachModel must not be null!");
            }
            this.artifactMap.put(ATTACH_MODEL_ENTRY_NAME, abstractModel3);
        } else {
            throw new IllegalStateException("Unknown ParserType '" + (Object)((Object)parserType) + "'!");
        }
        this.artifactMap.put(PARSER_TAGGER_MODEL_ENTRY_NAME, pOSModel);
        this.artifactMap.put(CHUNKER_TAGGER_MODEL_ENTRY_NAME, chunkerModel);
        this.artifactMap.put(HEAD_RULES_MODEL_ENTRY_NAME, headRules);
        this.checkArtifactMap();
    }

    public ParserModel(String string, AbstractModel abstractModel, AbstractModel abstractModel2, AbstractModel abstractModel3, POSModel pOSModel, ChunkerModel chunkerModel, HeadRules headRules, ParserType parserType) {
        this(string, abstractModel, abstractModel2, abstractModel3, pOSModel, chunkerModel, headRules, parserType, null);
    }

    public ParserModel(String string, AbstractModel abstractModel, AbstractModel abstractModel2, POSModel pOSModel, ChunkerModel chunkerModel, HeadRules headRules, ParserType parserType, Map<String, String> map) {
        this(string, abstractModel, abstractModel2, null, pOSModel, chunkerModel, headRules, parserType, map);
    }

    public ParserModel(InputStream inputStream) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, inputStream);
    }

    public ParserModel(File file) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, file);
    }

    public ParserModel(URL uRL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, uRL);
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> map) {
        super.createArtifactSerializers(map);
        map.put("postagger", new POSModelSerializer());
        map.put("chunker", new ChunkerModelSerializer());
        map.put("headrules", new HeadRulesSerializer());
    }

    public ParserType getParserType() {
        return ParserType.parse(this.getManifestProperty(PARSER_TYPE));
    }

    public AbstractModel getBuildModel() {
        return (AbstractModel)this.artifactMap.get(BUILD_MODEL_ENTRY_NAME);
    }

    public AbstractModel getCheckModel() {
        return (AbstractModel)this.artifactMap.get(CHECK_MODEL_ENTRY_NAME);
    }

    public AbstractModel getAttachModel() {
        return (AbstractModel)this.artifactMap.get(ATTACH_MODEL_ENTRY_NAME);
    }

    public POSModel getParserTaggerModel() {
        return (POSModel)this.artifactMap.get(PARSER_TAGGER_MODEL_ENTRY_NAME);
    }

    public ChunkerModel getParserChunkerModel() {
        return (ChunkerModel)this.artifactMap.get(CHUNKER_TAGGER_MODEL_ENTRY_NAME);
    }

    public HeadRules getHeadRules() {
        return (HeadRules)this.artifactMap.get(HEAD_RULES_MODEL_ENTRY_NAME);
    }

    public ParserModel updateBuildModel(AbstractModel abstractModel) {
        return new ParserModel(this.getLanguage(), abstractModel, this.getCheckModel(), this.getAttachModel(), this.getParserTaggerModel(), this.getParserChunkerModel(), this.getHeadRules(), this.getParserType());
    }

    public ParserModel updateCheckModel(AbstractModel abstractModel) {
        return new ParserModel(this.getLanguage(), this.getBuildModel(), abstractModel, this.getAttachModel(), this.getParserTaggerModel(), this.getParserChunkerModel(), this.getHeadRules(), this.getParserType());
    }

    public ParserModel updateTaggerModel(POSModel pOSModel) {
        return new ParserModel(this.getLanguage(), this.getBuildModel(), this.getCheckModel(), this.getAttachModel(), pOSModel, this.getParserChunkerModel(), this.getHeadRules(), this.getParserType());
    }

    public ParserModel updateChunkerModel(ChunkerModel chunkerModel) {
        return new ParserModel(this.getLanguage(), this.getBuildModel(), this.getCheckModel(), this.getAttachModel(), this.getParserTaggerModel(), chunkerModel, this.getHeadRules(), this.getParserType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(BUILD_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Missing the build model!");
        }
        ParserType parserType = this.getParserType();
        if (parserType == null) throw new InvalidFormatException("Missing the parser type property!");
        if (ParserType.CHUNKING.equals((Object)parserType)) {
            if (this.artifactMap.get(ATTACH_MODEL_ENTRY_NAME) != null) {
                throw new InvalidFormatException("attachModel must be null for chunking parser!");
            }
        } else {
            if (!ParserType.TREEINSERT.equals((Object)parserType)) throw new InvalidFormatException("Unknown ParserType '" + (Object)((Object)parserType) + "'!");
            if (!(this.artifactMap.get(ATTACH_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
                throw new InvalidFormatException("attachModel must not be null!");
            }
        }
        if (!(this.artifactMap.get(CHECK_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Missing the check model!");
        }
        if (!(this.artifactMap.get(PARSER_TAGGER_MODEL_ENTRY_NAME) instanceof POSModel)) {
            throw new InvalidFormatException("Missing the tagger model!");
        }
        if (!(this.artifactMap.get(CHUNKER_TAGGER_MODEL_ENTRY_NAME) instanceof ChunkerModel)) {
            throw new InvalidFormatException("Missing the chunker model!");
        }
        if (this.artifactMap.get(HEAD_RULES_MODEL_ENTRY_NAME) instanceof chalk.tools.parser.HeadRules) return;
        throw new InvalidFormatException("Missing the head rules!");
    }

    private static class HeadRulesSerializer
    implements ArtifactSerializer<HeadRules> {
        private HeadRulesSerializer() {
        }

        @Override
        public HeadRules create(InputStream inputStream) throws IOException, InvalidFormatException {
            return new HeadRules(new BufferedReader(new InputStreamReader(inputStream, "UTF-8")));
        }

        @Override
        public void serialize(HeadRules headRules, OutputStream outputStream) throws IOException {
            headRules.serialize(new OutputStreamWriter(outputStream, "UTF-8"));
        }
    }

    private static class ChunkerModelSerializer
    implements ArtifactSerializer<ChunkerModel> {
        private ChunkerModelSerializer() {
        }

        @Override
        public ChunkerModel create(InputStream inputStream) throws IOException, InvalidFormatException {
            return new ChunkerModel(new UncloseableInputStream(inputStream));
        }

        @Override
        public void serialize(ChunkerModel chunkerModel, OutputStream outputStream) throws IOException {
            chunkerModel.serialize(outputStream);
        }
    }

    private static class POSModelSerializer
    implements ArtifactSerializer<POSModel> {
        private POSModelSerializer() {
        }

        @Override
        public POSModel create(InputStream inputStream) throws IOException, InvalidFormatException {
            return new POSModel(new UncloseableInputStream(inputStream));
        }

        @Override
        public void serialize(POSModel pOSModel, OutputStream outputStream) throws IOException {
            pOSModel.serialize(outputStream);
        }
    }
}

