/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.parser.chunking;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.chunker.Chunker;
import chalk.tools.chunker.ChunkerME;
import chalk.tools.chunker.ChunkerModel;
import chalk.tools.dictionary.Dictionary;
import chalk.tools.parser.AbstractBottomUpParser;
import chalk.tools.parser.ChunkContextGenerator;
import chalk.tools.parser.ChunkSampleStream;
import chalk.tools.parser.HeadRules;
import chalk.tools.parser.Parse;
import chalk.tools.parser.ParserChunkerSequenceValidator;
import chalk.tools.parser.ParserEventTypeEnum;
import chalk.tools.parser.ParserModel;
import chalk.tools.parser.ParserType;
import chalk.tools.parser.PosSampleStream;
import chalk.tools.parser.chunking.BuildContextGenerator;
import chalk.tools.parser.chunking.CheckContextGenerator;
import chalk.tools.parser.chunking.ParserEventStream;
import chalk.tools.postag.POSModel;
import chalk.tools.postag.POSTagger;
import chalk.tools.postag.POSTaggerME;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Span;
import chalk.tools.util.TrainingParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nak.maxent.GIS;
import nak.model.AbstractModel;
import nak.model.DataIndexer;
import nak.model.EventStream;
import nak.model.MaxentModel;
import nak.model.TrainUtil;
import nak.model.TwoPassDataIndexer;

public class Parser
extends AbstractBottomUpParser {
    private MaxentModel buildModel;
    private MaxentModel checkModel;
    private BuildContextGenerator buildContextGenerator;
    private CheckContextGenerator checkContextGenerator;
    private double[] bprobs;
    private double[] cprobs;
    private static final String TOP_START = "S-TOP";
    private int topStartIndex;
    private Map<String, String> startTypeMap;
    private Map<String, String> contTypeMap;
    private int completeIndex;
    private int incompleteIndex;

    public Parser(ParserModel parserModel, int n, double d) {
        this((MaxentModel)parserModel.getBuildModel(), (MaxentModel)parserModel.getCheckModel(), new POSTaggerME(parserModel.getParserTaggerModel(), 10, 0), new ChunkerME(parserModel.getParserChunkerModel(), 10, new ParserChunkerSequenceValidator(parserModel.getParserChunkerModel()), new ChunkContextGenerator(10)), parserModel.getHeadRules(), n, d);
    }

    public Parser(ParserModel parserModel) {
        this(parserModel, 20, 0.95);
    }

    @Deprecated
    public Parser(MaxentModel maxentModel, MaxentModel maxentModel2, POSTagger pOSTagger, Chunker chunker, HeadRules headRules) {
        this(maxentModel, maxentModel2, pOSTagger, chunker, headRules, 20, 0.95);
    }

    @Deprecated
    public Parser(MaxentModel maxentModel, MaxentModel maxentModel2, POSTagger pOSTagger, Chunker chunker, HeadRules headRules, int n, double d) {
        super(pOSTagger, chunker, headRules, n, d);
        this.buildModel = maxentModel;
        this.checkModel = maxentModel2;
        this.bprobs = new double[maxentModel.getNumOutcomes()];
        this.cprobs = new double[maxentModel2.getNumOutcomes()];
        this.buildContextGenerator = new BuildContextGenerator();
        this.checkContextGenerator = new CheckContextGenerator();
        this.startTypeMap = new HashMap<String, String>();
        this.contTypeMap = new HashMap<String, String>();
        int n2 = maxentModel.getNumOutcomes();
        for (int i = 0; i < n2; ++i) {
            String string = maxentModel.getOutcome(i);
            if (string.startsWith("S-")) {
                this.startTypeMap.put(string, string.substring("S-".length()));
                continue;
            }
            if (!string.startsWith("C-")) continue;
            this.contTypeMap.put(string, string.substring("C-".length()));
        }
        this.topStartIndex = maxentModel.getIndex(TOP_START);
        this.completeIndex = maxentModel2.getIndex("c");
        this.incompleteIndex = maxentModel2.getIndex("i");
    }

    @Override
    protected void advanceTop(Parse parse) {
        this.buildModel.eval(this.buildContextGenerator.getContext(parse.getChildren(), 0), this.bprobs);
        parse.addProb(Math.log(this.bprobs[this.topStartIndex]));
        this.checkModel.eval(this.checkContextGenerator.getContext(parse.getChildren(), "TOP", 0, 0), this.cprobs);
        parse.addProb(Math.log(this.cprobs[this.completeIndex]));
        parse.setType("TOP");
    }

    @Override
    protected Parse[] advanceParses(Parse parse, double d) {
        int n;
        double d2 = 1.0 - d;
        Parse parse2 = null;
        int n2 = -1;
        String string = null;
        Parse parse3 = null;
        Parse[] parseArray = parse.getChildren();
        Parse[] parseArray2 = Parser.collapsePunctuation(parseArray, this.punctSet);
        int n3 = parseArray2.length;
        if (n3 == 0) {
            return null;
        }
        for (n = 0; n < n3 && (parse3 = parseArray2[n]).getLabel() != null; ++n) {
            if (!this.startTypeMap.containsKey(parse3.getLabel())) continue;
            string = this.startTypeMap.get(parse3.getLabel());
            parse2 = parse3;
            n2 = n;
        }
        int n4 = this.mapParseIndex(n, parseArray2, parseArray);
        ArrayList<Parse> arrayList = new ArrayList<Parse>(this.buildModel.getNumOutcomes());
        this.buildModel.eval(this.buildContextGenerator.getContext(parseArray2, n), this.bprobs);
        double d3 = 0.0;
        while (d3 < d) {
            int n5 = 0;
            for (int i = 1; i < this.bprobs.length; ++i) {
                if (!(this.bprobs[i] > this.bprobs[n5])) continue;
                n5 = i;
            }
            if (this.bprobs[n5] == 0.0) break;
            double d4 = this.bprobs[n5];
            this.bprobs[n5] = 0.0;
            d3 += d4;
            String string2 = this.buildModel.getOutcome(n5);
            if (n5 == this.topStartIndex) continue;
            if (this.startTypeMap.containsKey(string2)) {
                n2 = n;
                parse2 = parse3;
                string = this.startTypeMap.get(string2);
            } else if (this.contTypeMap.containsKey(string2) && (parse2 == null || !string.equals(this.contTypeMap.get(string2)))) continue;
            Parse parse4 = (Parse)parse.clone();
            if (this.createDerivationString) {
                parse4.getDerivation().append(n5).append("-");
            }
            parse4.setChild(n4, string2);
            parse4.addProb(Math.log(d4));
            this.checkModel.eval(this.checkContextGenerator.getContext(Parser.collapsePunctuation(parse4.getChildren(), this.punctSet), string, n2, n), this.cprobs);
            Parse parse5 = parse4;
            if (this.cprobs[this.completeIndex] > d2) {
                parse5 = (Parse)parse4.clone();
                if (this.createDerivationString) {
                    parse5.getDerivation().append(1).append(".");
                }
                parse5.addProb(Math.log(this.cprobs[this.completeIndex]));
                Parse[] parseArray3 = new Parse[n - n2 + 1];
                boolean bl = true;
                parseArray3[0] = parse2;
                bl &= parseArray3[0].isPosTag();
                parseArray3[n - n2] = parse3;
                bl &= parseArray3[n - n2].isPosTag();
                for (int i = 1; i < n - n2; ++i) {
                    parseArray3[i] = parseArray2[i + n2];
                    bl &= parseArray3[i].isPosTag();
                }
                if (!bl) {
                    if (n2 == 0 && n == n3 - 1) {
                        parse5.insert(new Parse(parse.getText(), parse.getSpan(), string, this.cprobs[1], this.headRules.getHead(parseArray3, string)));
                    } else {
                        parse5.insert(new Parse(parse.getText(), new Span(parse2.getSpan().getStart(), parse3.getSpan().getEnd()), string, this.cprobs[1], this.headRules.getHead(parseArray3, string)));
                    }
                    arrayList.add(parse5);
                }
            }
            if (!(this.cprobs[this.incompleteIndex] > d2)) continue;
            if (this.createDerivationString) {
                parse4.getDerivation().append(0).append(".");
            }
            if (n == n3 - 1) continue;
            parse4.addProb(Math.log(this.cprobs[this.incompleteIndex]));
            arrayList.add(parse4);
        }
        Parse[] parseArray4 = new Parse[arrayList.size()];
        arrayList.toArray(parseArray4);
        return parseArray4;
    }

    @Deprecated
    public static AbstractModel train(EventStream eventStream, int n, int n2) throws IOException {
        return GIS.trainModel((int)n, (DataIndexer)new TwoPassDataIndexer(eventStream, n2));
    }

    public static void mergeReportIntoManifest(Map<String, String> map, Map<String, String> map2, String string) {
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            map.put(string + "." + entry.getKey(), entry.getValue());
        }
    }

    public static ParserModel train(String string, ObjectStream<Parse> objectStream, HeadRules headRules, TrainingParameters trainingParameters) throws IOException {
        System.err.println("Building dictionary");
        Dictionary dictionary = Parser.buildDictionary(objectStream, headRules, trainingParameters);
        objectStream.reset();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        System.err.println("Training builder");
        ParserEventStream parserEventStream = new ParserEventStream(objectStream, headRules, ParserEventTypeEnum.BUILD, dictionary);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        AbstractModel abstractModel = TrainUtil.train((EventStream)parserEventStream, trainingParameters.getSettings("build"), hashMap2);
        Parser.mergeReportIntoManifest(hashMap, hashMap2, "build");
        objectStream.reset();
        POSModel pOSModel = POSTaggerME.train(string, new PosSampleStream(objectStream), trainingParameters.getParameters("tagger"), null, null);
        objectStream.reset();
        ChunkerModel chunkerModel = ChunkerME.train(string, (ObjectStream<ChunkSample>)new ChunkSampleStream(objectStream), new ChunkContextGenerator(), trainingParameters.getParameters("chunker"));
        objectStream.reset();
        System.err.println("Training checker");
        ParserEventStream parserEventStream2 = new ParserEventStream(objectStream, headRules, ParserEventTypeEnum.CHECK);
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        AbstractModel abstractModel2 = TrainUtil.train((EventStream)parserEventStream2, trainingParameters.getSettings("check"), hashMap3);
        Parser.mergeReportIntoManifest(hashMap, hashMap3, "check");
        return new ParserModel(string, abstractModel, abstractModel2, pOSModel, chunkerModel, (chalk.tools.parser.lang.en.HeadRules)headRules, ParserType.CHUNKING, hashMap);
    }

    @Deprecated
    public static ParserModel train(String string, ObjectStream<Parse> objectStream, HeadRules headRules, int n, int n2) throws IOException {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("dict", "Cutoff", Integer.toString(n2));
        trainingParameters.put("tagger", "Cutoff", Integer.toString(n2));
        trainingParameters.put("tagger", "Iterations", Integer.toString(n));
        trainingParameters.put("chunker", "Cutoff", Integer.toString(n2));
        trainingParameters.put("chunker", "Iterations", Integer.toString(n));
        trainingParameters.put("check", "Cutoff", Integer.toString(n2));
        trainingParameters.put("check", "Iterations", Integer.toString(n));
        trainingParameters.put("build", "Cutoff", Integer.toString(n2));
        trainingParameters.put("build", "Iterations", Integer.toString(n));
        return Parser.train(string, objectStream, headRules, trainingParameters);
    }
}

