/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.parser.chunking;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.parser.AbstractBottomUpParser;
import chalk.tools.parser.AbstractParserEventStream;
import chalk.tools.parser.HeadRules;
import chalk.tools.parser.Parse;
import chalk.tools.parser.ParseSampleStream;
import chalk.tools.parser.ParserEventTypeEnum;
import chalk.tools.parser.chunking.BuildContextGenerator;
import chalk.tools.parser.chunking.CheckContextGenerator;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import nak.model.Event;

public class ParserEventStream
extends AbstractParserEventStream {
    protected BuildContextGenerator bcg;
    protected CheckContextGenerator kcg;

    public ParserEventStream(ObjectStream<Parse> objectStream, HeadRules headRules, ParserEventTypeEnum parserEventTypeEnum, Dictionary dictionary) {
        super(objectStream, headRules, parserEventTypeEnum, dictionary);
    }

    @Override
    protected void init() {
        if (this.etype == ParserEventTypeEnum.BUILD) {
            this.bcg = new BuildContextGenerator(this.dict);
        } else if (this.etype == ParserEventTypeEnum.CHECK) {
            this.kcg = new CheckContextGenerator();
        }
    }

    public ParserEventStream(ObjectStream<Parse> objectStream, HeadRules headRules, ParserEventTypeEnum parserEventTypeEnum) {
        this(objectStream, headRules, parserEventTypeEnum, null);
    }

    protected boolean firstChild(Parse parse, Parse parse2) {
        return AbstractBottomUpParser.collapsePunctuation(parse2.getChildren(), this.punctSet)[0] == parse;
    }

    public static Parse[] reduceChunks(Parse[] parseArray, int n, Parse parse) {
        Parse[] parseArray2;
        int n2;
        String string = parse.getType();
        int n3 = n;
        for (n2 = n; n2 >= 0 && parseArray[n2].getParent() == parse; --n2) {
        }
        ++n2;
        if (!string.equals("TOP")) {
            int n4;
            parseArray2 = new Parse[parseArray.length - (n3 - n2 + 1) + 1];
            int n5 = n2;
            for (n4 = 0; n4 < n5; ++n4) {
                parseArray2[n4] = parseArray[n4];
            }
            parseArray2[n2] = parse;
            parse.setPrevPunctuation(parseArray[n2].getPreviousPunctuationSet());
            parse.setNextPunctuation(parseArray[n3].getNextPunctuationSet());
            n4 = n2 + 1;
            for (n5 = n3 + 1; n5 < parseArray.length; ++n5) {
                parseArray2[n4] = parseArray[n5];
                ++n4;
            }
            n = n2 - 1;
        } else {
            parseArray2 = new Parse[]{};
        }
        return parseArray2;
    }

    @Override
    protected void addParseEvents(List<Event> list, Parse[] parseArray) {
        for (int i = 0; i < parseArray.length; ++i) {
            int n;
            Parse parse = parseArray[i];
            Parse parse2 = parse.getParent();
            if (parse2 == null) continue;
            String string = parse2.getType();
            String string2 = this.firstChild(parse, parse2) ? "S-" + string : "C-" + string;
            parse.setLabel(string2);
            if (this.etype == ParserEventTypeEnum.BUILD) {
                list.add(new Event(string2, this.bcg.getContext(parseArray, i)));
            }
            for (n = i - 1; n >= 0 && parseArray[n].getParent() == parse2; --n) {
            }
            if (this.lastChild(parse, parse2)) {
                int n2;
                if (this.etype == ParserEventTypeEnum.CHECK) {
                    list.add(new Event("c", this.kcg.getContext(parseArray, string, n + 1, i)));
                }
                for (n2 = i; n2 >= 0 && parseArray[n2].getParent() == parse2; --n2) {
                }
                parseArray = ParserEventStream.reduceChunks(parseArray, i, parse2);
                i = ++n2 - 1;
                continue;
            }
            if (this.etype != ParserEventTypeEnum.CHECK) continue;
            list.add(new Event("i", this.kcg.getContext(parseArray, string, n + 1, i)));
        }
    }

    public static void main(String[] stringArray) throws IOException, InvalidFormatException {
        int n;
        if (stringArray.length == 0) {
            System.err.println("Usage ParserEventStream -[tag|chunk|build|check|fun] head_rules [dictionary] < parses");
            System.exit(1);
        }
        ParserEventTypeEnum parserEventTypeEnum = null;
        boolean bl = false;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            if (stringArray[n].equals("-build")) {
                parserEventTypeEnum = ParserEventTypeEnum.BUILD;
                continue;
            }
            if (stringArray[n].equals("-check")) {
                parserEventTypeEnum = ParserEventTypeEnum.CHECK;
                continue;
            }
            if (stringArray[n].equals("-chunk")) {
                parserEventTypeEnum = ParserEventTypeEnum.CHUNK;
                continue;
            }
            if (stringArray[n].equals("-tag")) {
                parserEventTypeEnum = ParserEventTypeEnum.TAG;
                continue;
            }
            if (stringArray[n].equals("-fun")) {
                bl = true;
                continue;
            }
            System.err.println("Invalid option " + stringArray[n]);
            System.exit(1);
        }
        chalk.tools.parser.lang.en.HeadRules headRules = new chalk.tools.parser.lang.en.HeadRules(stringArray[n++]);
        Dictionary dictionary = null;
        if (n < stringArray.length) {
            dictionary = new Dictionary(new FileInputStream(stringArray[n++]), true);
        }
        if (bl) {
            Parse.useFunctionTags(true);
        }
        ParserEventStream parserEventStream = new ParserEventStream(new ParseSampleStream(new PlainTextByLineStream(new InputStreamReader(System.in))), headRules, parserEventTypeEnum, dictionary);
        while (parserEventStream.hasNext()) {
            System.out.println(parserEventStream.next());
        }
    }
}

