/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.parser.lang.en;

import chalk.tools.parser.Constituent;
import chalk.tools.parser.GapLabeler;
import chalk.tools.parser.Parse;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;

public class HeadRules
implements chalk.tools.parser.HeadRules,
GapLabeler {
    private Map<String, HeadRule> headRules;
    private Set<String> punctSet;

    @Deprecated
    public HeadRules(String string) throws IOException {
        this(new BufferedReader(new FileReader(string)));
    }

    public HeadRules(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.readHeadRules(bufferedReader);
        this.punctSet = new HashSet<String>();
        this.punctSet.add(".");
        this.punctSet.add(",");
        this.punctSet.add("``");
        this.punctSet.add("''");
    }

    @Override
    public Set<String> getPunctuationTags() {
        return this.punctSet;
    }

    @Override
    public Parse getHead(Parse[] parseArray, String string) {
        if (parseArray[0].getType() == "TK") {
            return null;
        }
        if (string.equals("NP") || string.equals("NX")) {
            int n;
            int n2;
            int n3;
            String[] stringArray = new String[]{"NN", "NNP", "NNPS", "NNS", "NX", "JJR", "POS"};
            for (n3 = parseArray.length - 1; n3 >= 0; --n3) {
                for (n2 = stringArray.length - 1; n2 >= 0; --n2) {
                    if (!parseArray[n3].getType().equals(stringArray[n2])) continue;
                    return parseArray[n3].getHead();
                }
            }
            for (n3 = 0; n3 < parseArray.length; ++n3) {
                if (!parseArray[n3].getType().equals("NP")) continue;
                return parseArray[n3].getHead();
            }
            String[] stringArray2 = new String[]{"$", "ADJP", "PRN"};
            for (n2 = parseArray.length - 1; n2 >= 0; --n2) {
                for (n = stringArray2.length - 1; n >= 0; --n) {
                    if (!parseArray[n2].getType().equals(stringArray2[n])) continue;
                    return parseArray[n2].getHead();
                }
            }
            String[] stringArray3 = new String[]{"JJ", "JJS", "RB", "QP"};
            for (n = parseArray.length - 1; n >= 0; --n) {
                for (int i = stringArray3.length - 1; i >= 0; --i) {
                    if (!parseArray[n].getType().equals(stringArray3[i])) continue;
                    return parseArray[n].getHead();
                }
            }
            return parseArray[parseArray.length - 1].getHead();
        }
        HeadRule headRule = this.headRules.get(string);
        if (headRule != null) {
            String[] stringArray = headRule.tags;
            int n = parseArray.length;
            int n4 = stringArray.length;
            if (headRule.leftToRight) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (!parseArray[j].getType().equals(stringArray[i])) continue;
                        return parseArray[j].getHead();
                    }
                }
                return parseArray[0].getHead();
            }
            for (int i = 0; i < n4; ++i) {
                for (int j = n - 1; j >= 0; --j) {
                    if (!parseArray[j].getType().equals(stringArray[i])) continue;
                    return parseArray[j].getHead();
                }
            }
            return parseArray[n - 1].getHead();
        }
        return parseArray[parseArray.length - 1].getHead();
    }

    private void readHeadRules(BufferedReader bufferedReader) throws IOException {
        String string;
        this.headRules = new HashMap<String, HeadRule>(30);
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String[] stringArray = new String[Integer.parseInt(string2) - 2];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            this.headRules.put(string3, new HeadRule(string4.equals("1"), stringArray));
        }
    }

    @Override
    public void labelGaps(Stack<Constituent> stack) {
        if (stack.size() > 4) {
            Constituent constituent = (Constituent)stack.get(stack.size() - 2);
            Constituent constituent2 = (Constituent)stack.get(stack.size() - 3);
            Constituent constituent3 = (Constituent)stack.get(stack.size() - 4);
            Constituent constituent4 = (Constituent)stack.get(stack.size() - 5);
            if (constituent.getLabel().equals("NP") && constituent2.getLabel().equals("S") && constituent3.getLabel().equals("SBAR")) {
                constituent.setLabel(constituent.getLabel() + "-G");
                constituent2.setLabel(constituent2.getLabel() + "-G");
                constituent3.setLabel(constituent3.getLabel() + "-G");
            } else if (constituent.getLabel().equals("NP") && constituent2.getLabel().equals("VP") && constituent3.getLabel().equals("S") && constituent4.getLabel().equals("SBAR")) {
                constituent.setLabel(constituent.getLabel() + "-G");
                constituent2.setLabel(constituent2.getLabel() + "-G");
                constituent3.setLabel(constituent3.getLabel() + "-G");
                constituent4.setLabel(constituent4.getLabel() + "-G");
            }
        }
    }

    public void serialize(Writer writer) throws IOException {
        for (String string : this.headRules.keySet()) {
            HeadRule headRule = this.headRules.get(string);
            writer.write(Integer.toString(headRule.tags.length + 2));
            writer.write(32);
            writer.write(string);
            writer.write(32);
            if (headRule.leftToRight) {
                writer.write("1");
            } else {
                writer.write("0");
            }
            for (String string2 : headRule.tags) {
                writer.write(32);
                writer.write(string2);
            }
            writer.write(10);
        }
        writer.flush();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof HeadRules) {
            HeadRules headRules = (HeadRules)object;
            return ((Object)headRules.headRules).equals(this.headRules) && ((Object)headRules.punctSet).equals(this.punctSet);
        }
        return false;
    }

    private static class HeadRule {
        public boolean leftToRight;
        public String[] tags;

        public HeadRule(boolean bl, String[] stringArray) {
            this.leftToRight = bl;
            for (String string : stringArray) {
                if (string != null) continue;
                throw new IllegalArgumentException("tags must not contain null values!");
            }
            this.tags = stringArray;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof HeadRule) {
                HeadRule headRule = (HeadRule)object;
                return headRule.leftToRight == this.leftToRight && Arrays.equals(headRule.tags, this.tags);
            }
            return false;
        }
    }
}

