/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.parser.treeinsert;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.chunker.Chunker;
import chalk.tools.chunker.ChunkerME;
import chalk.tools.chunker.ChunkerModel;
import chalk.tools.dictionary.Dictionary;
import chalk.tools.parser.AbstractBottomUpParser;
import chalk.tools.parser.ChunkContextGenerator;
import chalk.tools.parser.ChunkSampleStream;
import chalk.tools.parser.HeadRules;
import chalk.tools.parser.Parse;
import chalk.tools.parser.ParserChunkerSequenceValidator;
import chalk.tools.parser.ParserEventTypeEnum;
import chalk.tools.parser.ParserModel;
import chalk.tools.parser.ParserType;
import chalk.tools.parser.PosSampleStream;
import chalk.tools.parser.treeinsert.AttachContextGenerator;
import chalk.tools.parser.treeinsert.BuildContextGenerator;
import chalk.tools.parser.treeinsert.CheckContextGenerator;
import chalk.tools.parser.treeinsert.ParserEventStream;
import chalk.tools.postag.POSModel;
import chalk.tools.postag.POSTagger;
import chalk.tools.postag.POSTaggerME;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.TrainingParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import nak.maxent.GIS;
import nak.model.AbstractModel;
import nak.model.DataIndexer;
import nak.model.EventStream;
import nak.model.MaxentModel;
import nak.model.TrainUtil;
import nak.model.TwoPassDataIndexer;

public class Parser
extends AbstractBottomUpParser {
    public static final String DONE = "d";
    public static final String ATTACH_SISTER = "s";
    public static final String ATTACH_DAUGHTER = "d";
    public static final String NON_ATTACH = "n";
    public static final String BUILT = "built";
    private MaxentModel buildModel;
    private MaxentModel attachModel;
    private MaxentModel checkModel;
    static boolean checkComplete = false;
    private BuildContextGenerator buildContextGenerator;
    private AttachContextGenerator attachContextGenerator;
    private CheckContextGenerator checkContextGenerator;
    private double[] bprobs;
    private double[] aprobs;
    private double[] cprobs;
    private int doneIndex;
    private int sisterAttachIndex;
    private int daughterAttachIndex;
    private int nonAttachIndex;
    private int completeIndex;
    private int[] attachments;

    public Parser(ParserModel parserModel, int n, double d) {
        this(parserModel.getBuildModel(), parserModel.getAttachModel(), parserModel.getCheckModel(), new POSTaggerME(parserModel.getParserTaggerModel()), new ChunkerME(parserModel.getParserChunkerModel(), 10, new ParserChunkerSequenceValidator(parserModel.getParserChunkerModel()), new ChunkContextGenerator(10)), parserModel.getHeadRules(), n, d);
    }

    public Parser(ParserModel parserModel) {
        this(parserModel, 20, 0.95);
    }

    @Deprecated
    public Parser(AbstractModel abstractModel, AbstractModel abstractModel2, AbstractModel abstractModel3, POSTagger pOSTagger, Chunker chunker, HeadRules headRules, int n, double d) {
        super(pOSTagger, chunker, headRules, n, d);
        this.buildModel = abstractModel;
        this.attachModel = abstractModel2;
        this.checkModel = abstractModel3;
        this.buildContextGenerator = new BuildContextGenerator();
        this.attachContextGenerator = new AttachContextGenerator(this.punctSet);
        this.checkContextGenerator = new CheckContextGenerator(this.punctSet);
        this.bprobs = new double[abstractModel.getNumOutcomes()];
        this.aprobs = new double[abstractModel2.getNumOutcomes()];
        this.cprobs = new double[abstractModel3.getNumOutcomes()];
        this.doneIndex = abstractModel.getIndex("d");
        this.sisterAttachIndex = abstractModel2.getIndex(ATTACH_SISTER);
        this.daughterAttachIndex = abstractModel2.getIndex("d");
        this.nonAttachIndex = abstractModel2.getIndex(NON_ATTACH);
        this.attachments = new int[]{this.daughterAttachIndex, this.sisterAttachIndex};
        this.completeIndex = abstractModel3.getIndex("c");
    }

    @Deprecated
    public Parser(AbstractModel abstractModel, AbstractModel abstractModel2, AbstractModel abstractModel3, POSTagger pOSTagger, Chunker chunker, HeadRules headRules) {
        this(abstractModel, abstractModel2, abstractModel3, pOSTagger, chunker, headRules, 20, 0.95);
    }

    public static List<Parse> getRightFrontier(Parse parse, Set<String> set) {
        LinkedList<Parse> linkedList = new LinkedList<Parse>();
        Parse parse2 = parse.getType() == "TOP" || parse.getType() == "INC" ? Parser.collapsePunctuation(parse.getChildren(), set)[0] : parse;
        while (!parse2.isPosTag()) {
            linkedList.add(0, parse2);
            Parse[] parseArray = parse2.getChildren();
            parse2 = parseArray[parseArray.length - 1];
        }
        return new ArrayList<Parse>(linkedList);
    }

    private void setBuilt(Parse parse) {
        String string = parse.getLabel();
        if (string == null) {
            parse.setLabel(BUILT);
        } else if (this.isComplete(parse)) {
            parse.setLabel("built.c");
        } else {
            parse.setLabel("built.i");
        }
    }

    private void setComplete(Parse parse) {
        String string = parse.getLabel();
        if (!this.isBuilt(parse)) {
            parse.setLabel("c");
        } else {
            parse.setLabel("built.c");
        }
    }

    private void setIncomplete(Parse parse) {
        if (!this.isBuilt(parse)) {
            parse.setLabel("i");
        } else {
            parse.setLabel("built.i");
        }
    }

    private boolean isBuilt(Parse parse) {
        String string = parse.getLabel();
        if (string == null) {
            return false;
        }
        return string.startsWith(BUILT);
    }

    private boolean isComplete(Parse parse) {
        String string = parse.getLabel();
        if (string == null) {
            return false;
        }
        return string.endsWith("c");
    }

    @Override
    protected Parse[] advanceChunks(Parse parse, double d) {
        Parse[] parseArray = super.advanceChunks(parse, d);
        for (int i = 0; i < parseArray.length; ++i) {
            Parse[] parseArray2 = parseArray[i].getChildren();
            for (int j = 0; j < parseArray2.length; ++j) {
                this.setComplete(parseArray2[j]);
            }
        }
        return parseArray;
    }

    @Override
    protected Parse[] advanceParses(Parse parse, double d) {
        Parse[] parseArray;
        Parse parse2;
        int n;
        int n2;
        int n3;
        double d2 = 1.0 - d;
        Parse parse3 = null;
        Parse[] parseArray2 = parse.getChildren();
        Parse[] parseArray3 = Parser.collapsePunctuation(parseArray2, this.punctSet);
        int n4 = parseArray3.length;
        if (n4 == 0) {
            return null;
        }
        if (n4 == 1) {
            if (parseArray3[0].isPosTag()) {
                return null;
            }
            parse.expandTopNode(parseArray3[0]);
            return new Parse[]{parse};
        }
        for (n3 = 0; n3 < n4 && this.isBuilt(parse3 = parseArray3[n3]); ++n3) {
        }
        int n5 = this.mapParseIndex(0, parseArray3, parseArray2);
        int n6 = this.mapParseIndex(n3, parseArray3, parseArray2);
        ArrayList<Parse> arrayList = new ArrayList<Parse>();
        this.buildModel.eval(this.buildContextGenerator.getContext(parseArray3, n3), this.bprobs);
        double d3 = this.bprobs[this.doneIndex];
        if (this.debugOn) {
            System.out.println("adi=" + n3 + " " + parse3.getType() + "." + parse3.getLabel() + " " + parse3 + " choose build=" + (1.0 - d3) + " attach=" + d3);
        }
        if (1.0 - d3 > d2) {
            double d4 = 0.0;
            while (d4 < d) {
                n2 = 0;
                for (n = 1; n < this.bprobs.length; ++n) {
                    if (!(this.bprobs[n] > this.bprobs[n2])) continue;
                    n2 = n;
                }
                if (this.bprobs[n2] == 0.0) break;
                double d5 = this.bprobs[n2];
                this.bprobs[n2] = 0.0;
                d4 += d5;
                String string = this.buildModel.getOutcome(n2);
                if (string.equals("d")) continue;
                Parse parse4 = (Parse)parse.clone();
                Parse parse5 = new Parse(parse.getText(), parse3.getSpan(), string, d5, parse3.getHead());
                parse4.insert(parse5);
                parse4.addProb(Math.log(d5));
                arrayList.add(parse4);
                if (checkComplete) {
                    this.cprobs = this.checkModel.eval(this.checkContextGenerator.getContext(parse5, parseArray3, n3, false));
                    if (this.debugOn) {
                        System.out.println("building " + string + " " + d5 + " c=" + this.cprobs[this.completeIndex]);
                    }
                    if (this.cprobs[this.completeIndex] > d) {
                        this.setComplete(parse5);
                        parse4.addProb(Math.log(this.cprobs[this.completeIndex]));
                        if (!this.debugOn) continue;
                        System.out.println("Only advancing complete node");
                        continue;
                    }
                    if (1.0 - this.cprobs[this.completeIndex] > d) {
                        this.setIncomplete(parse5);
                        parse4.addProb(Math.log(1.0 - this.cprobs[this.completeIndex]));
                        if (!this.debugOn) continue;
                        System.out.println("Only advancing incomplete node");
                        continue;
                    }
                    if (this.debugOn) {
                        System.out.println("Advancing both complete and incomplete nodes");
                    }
                    this.setComplete(parse5);
                    parse4.addProb(Math.log(this.cprobs[this.completeIndex]));
                    parse2 = (Parse)parse.clone();
                    parseArray = new Parse(parse.getText(), parse3.getSpan(), string, d5, parse3.getHead());
                    parse2.insert((Parse)parseArray);
                    parse2.addProb(Math.log(d5));
                    arrayList.add(parse2);
                    parse2.addProb(Math.log(1.0 - this.cprobs[this.completeIndex]));
                    this.setIncomplete((Parse)parseArray);
                    continue;
                }
                if (!this.debugOn) continue;
                System.out.println("building " + string + " " + d5);
            }
        }
        if (d3 > d2) {
            Parse parse6 = (Parse)parse.clone();
            if (checkComplete) {
                if (this.isComplete(parse3)) {
                    parse6.setChild(n6, "built.c");
                } else {
                    parse6.setChild(n6, "built.i");
                }
            } else {
                parse6.setChild(n6, BUILT);
            }
            parse6.addProb(Math.log(d3));
            if (n3 == 0) {
                arrayList.add(parse6);
            } else {
                List<Parse> list = Parser.getRightFrontier(parse, this.punctSet);
                n = list.size();
                for (n2 = 0; n2 < n; ++n2) {
                    Parse parse7 = list.get(n2);
                    this.attachModel.eval(this.attachContextGenerator.getContext(parseArray3, n3, list, n2), this.aprobs);
                    if (this.debugOn) {
                        System.out.println("Frontier node(" + n2 + "): " + parse7.getType() + "." + parse7.getLabel() + " " + parse7 + " <- " + parse3.getType() + " " + parse3 + " d=" + this.aprobs[this.daughterAttachIndex] + " s=" + this.aprobs[this.sisterAttachIndex] + " ");
                    }
                    for (int i = 0; i < this.attachments.length; ++i) {
                        double d6 = this.aprobs[this.attachments[i]];
                        if (d6 > d2 && (!checkComplete && (this.attachments[i] != this.daughterAttachIndex || !this.isComplete(parse7)) || checkComplete && (this.attachments[i] == this.daughterAttachIndex && !this.isComplete(parse7) || this.attachments[i] == this.sisterAttachIndex && this.isComplete(parse7)))) {
                            Parse parse8;
                            parse2 = parse6.cloneRoot(parse7, n5);
                            parseArray = Parser.collapsePunctuation(parse2.getChildren(), this.punctSet);
                            for (int j = n5 + 1; j <= n6; ++j) {
                                parse2.remove(n5 + 1);
                            }
                            List<Parse> list2 = Parser.getRightFrontier(parse2, this.punctSet);
                            if (this.attachments[i] == this.daughterAttachIndex) {
                                parse8 = list2.get(n2);
                                parse8.add(parse3, this.headRules);
                            } else if (n2 + 1 < list2.size()) {
                                Parse parse9 = list2.get(n2 + 1);
                                parse8 = parse9.adjoin(parse3, this.headRules);
                            } else {
                                Parse parse10 = parse2;
                                parseArray[0] = parse8 = parse10.adjoinRoot(parse3, this.headRules, n5);
                            }
                            for (int j = n2 + 1; j < list2.size(); ++j) {
                                Parse parse11 = list2.get(j);
                                parse11.updateSpan();
                            }
                            parse2.addProb(Math.log(d6));
                            arrayList.add(parse2);
                            if (!checkComplete) continue;
                            this.cprobs = this.checkModel.eval(this.checkContextGenerator.getContext(parse8, parseArray, n3, true));
                            if (this.cprobs[this.completeIndex] > d) {
                                this.setComplete(parse8);
                                parse2.addProb(Math.log(this.cprobs[this.completeIndex]));
                                if (!this.debugOn) continue;
                                System.out.println("Only advancing complete node");
                                continue;
                            }
                            if (1.0 - this.cprobs[this.completeIndex] > d) {
                                this.setIncomplete(parse8);
                                parse2.addProb(Math.log(1.0 - this.cprobs[this.completeIndex]));
                                if (!this.debugOn) continue;
                                System.out.println("Only advancing incomplete node");
                                continue;
                            }
                            this.setComplete(parse8);
                            Parse parse12 = parse2.cloneRoot(parse8, n5);
                            parse12.addProb(Math.log(this.cprobs[this.completeIndex]));
                            arrayList.add(parse12);
                            this.setIncomplete(parse8);
                            parse2.addProb(Math.log(1.0 - this.cprobs[this.completeIndex]));
                            if (!this.debugOn) continue;
                            System.out.println("Advancing both complete and incomplete nodes; c=" + this.cprobs[this.completeIndex]);
                            continue;
                        }
                        if (!this.debugOn) continue;
                        System.out.println("Skipping " + parse7.getType() + "." + parse7.getLabel() + " " + parse7 + " daughter=" + (this.attachments[i] == this.daughterAttachIndex) + " complete=" + this.isComplete(parse7) + " prob=" + d6);
                    }
                    if (!checkComplete || this.isComplete(parse7)) continue;
                    if (!this.debugOn) break;
                    System.out.println("Stopping at incomplete node(" + n2 + "): " + parse7.getType() + "." + parse7.getLabel() + " " + parse7);
                    break;
                }
            }
        }
        Parse[] parseArray4 = new Parse[arrayList.size()];
        arrayList.toArray(parseArray4);
        return parseArray4;
    }

    @Override
    protected void advanceTop(Parse parse) {
        parse.setType("TOP");
    }

    public static ParserModel train(String string, ObjectStream<Parse> objectStream, HeadRules headRules, TrainingParameters trainingParameters) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        System.err.println("Building dictionary");
        Dictionary dictionary = Parser.buildDictionary(objectStream, headRules, trainingParameters);
        objectStream.reset();
        POSModel pOSModel = POSTaggerME.train(string, new PosSampleStream(objectStream), trainingParameters.getParameters("tagger"), null, null);
        objectStream.reset();
        ChunkerModel chunkerModel = ChunkerME.train(string, (ObjectStream<ChunkSample>)new ChunkSampleStream(objectStream), new ChunkContextGenerator(), trainingParameters.getParameters("chunker"));
        objectStream.reset();
        System.err.println("Training builder");
        ParserEventStream parserEventStream = new ParserEventStream(objectStream, headRules, ParserEventTypeEnum.BUILD, dictionary);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        AbstractModel abstractModel = TrainUtil.train((EventStream)parserEventStream, trainingParameters.getSettings("build"), hashMap2);
        chalk.tools.parser.chunking.Parser.mergeReportIntoManifest(hashMap, hashMap2, "build");
        objectStream.reset();
        System.err.println("Training checker");
        ParserEventStream parserEventStream2 = new ParserEventStream(objectStream, headRules, ParserEventTypeEnum.CHECK);
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        AbstractModel abstractModel2 = TrainUtil.train((EventStream)parserEventStream2, trainingParameters.getSettings("check"), hashMap3);
        chalk.tools.parser.chunking.Parser.mergeReportIntoManifest(hashMap, hashMap3, "check");
        objectStream.reset();
        System.err.println("Training attacher");
        ParserEventStream parserEventStream3 = new ParserEventStream(objectStream, headRules, ParserEventTypeEnum.ATTACH);
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        AbstractModel abstractModel3 = TrainUtil.train((EventStream)parserEventStream3, trainingParameters.getSettings("attach"), hashMap4);
        chalk.tools.parser.chunking.Parser.mergeReportIntoManifest(hashMap, hashMap4, "attach");
        return new ParserModel(string, abstractModel, abstractModel2, abstractModel3, pOSModel, chunkerModel, (chalk.tools.parser.lang.en.HeadRules)headRules, ParserType.TREEINSERT, hashMap);
    }

    public static ParserModel train(String string, ObjectStream<Parse> objectStream, HeadRules headRules, int n, int n2) throws IOException {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("dict", "Cutoff", Integer.toString(n2));
        trainingParameters.put("tagger", "Cutoff", Integer.toString(n2));
        trainingParameters.put("tagger", "Iterations", Integer.toString(n));
        trainingParameters.put("chunker", "Cutoff", Integer.toString(n2));
        trainingParameters.put("chunker", "Iterations", Integer.toString(n));
        trainingParameters.put("check", "Cutoff", Integer.toString(n2));
        trainingParameters.put("check", "Iterations", Integer.toString(n));
        trainingParameters.put("build", "Cutoff", Integer.toString(n2));
        trainingParameters.put("build", "Iterations", Integer.toString(n));
        return Parser.train(string, objectStream, headRules, trainingParameters);
    }

    @Deprecated
    public static AbstractModel train(EventStream eventStream, int n, int n2) throws IOException {
        return GIS.trainModel((int)n, (DataIndexer)new TwoPassDataIndexer(eventStream, n2));
    }
}

