/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.parser.treeinsert;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.parser.AbstractParserEventStream;
import chalk.tools.parser.HeadRules;
import chalk.tools.parser.Parse;
import chalk.tools.parser.ParseSampleStream;
import chalk.tools.parser.ParserEventTypeEnum;
import chalk.tools.parser.treeinsert.AttachContextGenerator;
import chalk.tools.parser.treeinsert.BuildContextGenerator;
import chalk.tools.parser.treeinsert.CheckContextGenerator;
import chalk.tools.parser.treeinsert.Parser;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nak.io.SuffixSensitiveGISModelReader;
import nak.model.AbstractModel;
import nak.model.Event;

public class ParserEventStream
extends AbstractParserEventStream {
    protected AttachContextGenerator attachContextGenerator;
    protected BuildContextGenerator buildContextGenerator;
    protected CheckContextGenerator checkContextGenerator;
    private static final boolean debug = false;

    public ParserEventStream(ObjectStream<Parse> objectStream, HeadRules headRules, ParserEventTypeEnum parserEventTypeEnum, Dictionary dictionary) {
        super(objectStream, headRules, parserEventTypeEnum, dictionary);
    }

    @Override
    public void init() {
        this.buildContextGenerator = new BuildContextGenerator();
        this.attachContextGenerator = new AttachContextGenerator(this.punctSet);
        this.checkContextGenerator = new CheckContextGenerator(this.punctSet);
    }

    public ParserEventStream(ObjectStream<Parse> objectStream, HeadRules headRules, ParserEventTypeEnum parserEventTypeEnum) {
        super(objectStream, headRules, parserEventTypeEnum);
    }

    private Map<Parse, Integer> getNonAdjoinedParent(Parse parse) {
        HashMap<Parse, Integer> hashMap = new HashMap<Parse, Integer>();
        Parse parse2 = parse.getParent();
        int n = this.indexOf(parse, parse2);
        hashMap.put(parse2, n);
        while (parse2.getType().equals(parse.getType())) {
            parse = parse2;
            parse2 = parse2.getParent();
            n = this.indexOf(parse, parse2);
            hashMap.put(parse2, n);
        }
        return hashMap;
    }

    private int indexOf(Parse parse, Parse parse2) {
        Parse[] parseArray = Parser.collapsePunctuation(parse2.getChildren(), this.punctSet);
        for (int i = 0; i < parseArray.length; ++i) {
            if (parse != parseArray[i]) continue;
            return i;
        }
        return -1;
    }

    private int nonPunctChildCount(Parse parse) {
        return Parser.collapsePunctuation(parse.getChildren(), this.punctSet).length;
    }

    @Override
    protected boolean lastChild(Parse parse, Parse parse2) {
        Parse parse3;
        boolean bl = super.lastChild(parse, parse2);
        while (!bl && (parse3 = parse.getParent()) != parse2 && parse3.getType().equals(parse.getType())) {
            bl = super.lastChild(parse3, parse2);
            parse = parse3;
        }
        return bl;
    }

    @Override
    protected void addParseEvents(List<Event> list, Parse[] parseArray) {
        int n;
        ArrayList<Parse> arrayList = new ArrayList<Parse>();
        ArrayList<Parse> arrayList2 = new ArrayList<Parse>();
        Parse[] parseArray2 = new Parse[parseArray.length];
        for (n = 0; n < parseArray.length; ++n) {
            parseArray2[n] = (Parse)parseArray[n].clone();
            parseArray2[n].setPrevPunctuation(parseArray[n].getPreviousPunctuationSet());
            parseArray2[n].setNextPunctuation(parseArray[n].getNextPunctuationSet());
            parseArray2[n].setLabel("c");
            parseArray[n].setLabel("c");
        }
        for (n = 0; n < parseArray.length; ++n) {
            List<Parse> list2;
            Object object;
            Parse parse = parseArray[n].getParent();
            Parse parse2 = parseArray[n];
            int n2 = 0;
            if (!parseArray[n].isPosTag()) {
                arrayList2.add(n2++, parseArray[n]);
            }
            while (!parse.getType().equals("TOP") && parse.getLabel() == null) {
                if (parse.getLabel() == null && !parse2.getType().equals(parse.getType())) {
                    if (this.etype == ParserEventTypeEnum.BUILD) {
                        list.add(new Event(parse.getType(), this.buildContextGenerator.getContext(parseArray2, n)));
                    }
                    arrayList2.add(n2++, parse);
                    object = new Parse(parseArray2[n].getText(), parseArray2[n].getSpan(), parse.getType(), 1.0, 0);
                    ((Parse)object).add(parseArray2[n], this.rules);
                    ((Parse)object).setPrevPunctuation(parseArray2[n].getPreviousPunctuationSet());
                    ((Parse)object).setNextPunctuation(parseArray2[n].getNextPunctuationSet());
                    parseArray2[n].setParent((Parse)object);
                    parseArray2[n] = object;
                    ((Parse)object).setLabel("built");
                    if (this.lastChild(parseArray[n], parse)) {
                        if (this.etype == ParserEventTypeEnum.CHECK) {
                            list.add(new Event("c", this.checkContextGenerator.getContext(parseArray2[n], parseArray2, n, false)));
                        }
                        parseArray2[n].setLabel("c");
                        parse.setLabel("c");
                    } else {
                        if (this.etype == ParserEventTypeEnum.CHECK) {
                            list.add(new Event("i", this.checkContextGenerator.getContext(parseArray2[n], parseArray2, n, false)));
                        }
                        parseArray2[n].setLabel("i");
                        parse.setLabel("c");
                    }
                    parseArray[n] = parse;
                }
                parse.setLabel("built");
                parse2 = parse;
                parse = parse.getParent();
            }
            if (this.etype == ParserEventTypeEnum.BUILD) {
                list.add(new Event("d", this.buildContextGenerator.getContext(parseArray2, n)));
            }
            object = null;
            Parse parse3 = null;
            int n3 = -1;
            if (n == 0) {
                list2 = new Parse(parseArray2[n].getText(), new Span(0, parseArray2[n].getText().length()), "TOP", 1.0, 0);
                ((Parse)((Object)list2)).insert(parseArray2[n]);
            } else {
                Parse parse4;
                Parse parse5;
                int n4;
                list2 = Parser.getRightFrontier(parseArray2[0], this.punctSet);
                if (list2.size() != arrayList.size()) {
                    System.err.println("fontiers mis-aligned: " + list2.size() + " != " + arrayList.size() + " " + list2 + " " + arrayList);
                    System.exit(1);
                }
                Map<Parse, Integer> map = this.getNonAdjoinedParent(parseArray[n]);
                for (n4 = 0; n4 < list2.size(); ++n4) {
                    parse5 = (Parse)arrayList.get(n4);
                    parse4 = (Parse)list2.get(n4);
                    if (!Parser.checkComplete || !"c".equals(parse4.getLabel())) {
                        Integer n5 = map.get(parse5);
                        if (parse3 == null && n5 != null && n5.intValue() == this.nonPunctChildCount(parse4)) {
                            object = "d";
                            n3 = n4;
                            parse3 = parse4;
                            if (this.etype == ParserEventTypeEnum.ATTACH) {
                                list.add(new Event((String)object, this.attachContextGenerator.getContext(parseArray2, n, list2, n3)));
                            }
                        }
                    }
                    if (Parser.checkComplete && parse4.getLabel().equals("i")) break;
                }
                for (n4 = 0; n4 < list2.size(); ++n4) {
                    parse5 = (Parse)arrayList.get(n4);
                    parse4 = (Parse)list2.get(n4);
                    if (parse3 == null && map.containsKey(parse5.getParent()) && parse5.getType().equals(parse5.getParent().getType())) {
                        object = "s";
                        parse3 = parse4;
                        n3 = n4;
                        if (this.etype == ParserEventTypeEnum.ATTACH) {
                            list.add(new Event("s", this.attachContextGenerator.getContext(parseArray2, n, list2, n4)));
                        }
                        parseArray[n].getParent().setLabel("built");
                    } else if (n4 != n3 && this.etype == ParserEventTypeEnum.ATTACH) {
                        list.add(new Event("n", this.attachContextGenerator.getContext(parseArray2, n, list2, n4)));
                    }
                    if (Parser.checkComplete && parse4.getLabel().equals("i")) break;
                }
                if (parse3 != null) {
                    if (object == "d") {
                        Parse parse6 = parseArray2[n];
                        parse3.add(parse6, this.rules);
                        parse6.setParent(parse3);
                        if (this.lastChild(parseArray[n], (Parse)arrayList.get(n3))) {
                            if (this.etype == ParserEventTypeEnum.CHECK) {
                                list.add(new Event("c", this.checkContextGenerator.getContext(parse3, parseArray2, n, true)));
                            }
                            parse3.setLabel("c");
                        } else if (this.etype == ParserEventTypeEnum.CHECK) {
                            list.add(new Event("i", this.checkContextGenerator.getContext(parse3, parseArray2, n, true)));
                        }
                    } else if (object == "s") {
                        Parse parse7 = (Parse)arrayList.get(n3);
                        arrayList.set(n3, parse7.getParent());
                        parse5 = parseArray2[n];
                        parse4 = parse3.getParent().adjoin(parse5, this.rules);
                        parse4.setParent(parse3.getParent());
                        parse3.setParent(parse4);
                        parse5.setParent(parse4);
                        if (parse3 == parseArray2[0]) {
                            parseArray2[0] = parse4;
                        }
                        if (this.lastChild(parseArray[n], (Parse)arrayList.get(n3))) {
                            if (this.etype == ParserEventTypeEnum.CHECK) {
                                list.add(new Event("c", this.checkContextGenerator.getContext(parse4, parseArray2, n, true)));
                            }
                            parse4.setLabel("c");
                        } else {
                            if (this.etype == ParserEventTypeEnum.CHECK) {
                                list.add(new Event("i", this.checkContextGenerator.getContext(parse4, parseArray2, n, true)));
                            }
                            parse4.setLabel("i");
                        }
                    }
                    for (n4 = 0; n4 < n3; ++n4) {
                        arrayList.remove(0);
                    }
                } else {
                    throw new RuntimeException("No Attachment: " + parseArray[n]);
                }
            }
            arrayList.addAll(0, arrayList2);
            arrayList2.clear();
        }
    }

    public static void main(String[] stringArray) throws IOException, InvalidFormatException {
        int n;
        if (stringArray.length == 0) {
            System.err.println("Usage ParserEventStream -[tag|chunk|build|attach] [-fun] [-dict dictionary] [-model model] head_rules < parses");
            System.exit(1);
        }
        ParserEventTypeEnum parserEventTypeEnum = null;
        boolean bl = false;
        Dictionary dictionary = null;
        AbstractModel abstractModel = null;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            if (stringArray[n].equals("-build")) {
                parserEventTypeEnum = ParserEventTypeEnum.BUILD;
                continue;
            }
            if (stringArray[n].equals("-attach")) {
                parserEventTypeEnum = ParserEventTypeEnum.ATTACH;
                continue;
            }
            if (stringArray[n].equals("-chunk")) {
                parserEventTypeEnum = ParserEventTypeEnum.CHUNK;
                continue;
            }
            if (stringArray[n].equals("-check")) {
                parserEventTypeEnum = ParserEventTypeEnum.CHECK;
                continue;
            }
            if (stringArray[n].equals("-tag")) {
                parserEventTypeEnum = ParserEventTypeEnum.TAG;
                continue;
            }
            if (stringArray[n].equals("-fun")) {
                bl = true;
                continue;
            }
            if (stringArray[n].equals("-dict")) {
                dictionary = new Dictionary(new FileInputStream(stringArray[++n]));
                continue;
            }
            if (stringArray[n].equals("-model")) {
                abstractModel = new SuffixSensitiveGISModelReader(new File(stringArray[++n])).getModel();
                continue;
            }
            System.err.println("Invalid option " + stringArray[n]);
            System.exit(1);
        }
        chalk.tools.parser.lang.en.HeadRules headRules = new chalk.tools.parser.lang.en.HeadRules(stringArray[n++]);
        if (bl) {
            Parse.useFunctionTags(true);
        }
        ParserEventStream parserEventStream = new ParserEventStream(new ParseSampleStream(new PlainTextByLineStream(new InputStreamReader(System.in))), headRules, parserEventTypeEnum, dictionary);
        while (parserEventStream.hasNext()) {
            Event event = parserEventStream.next();
            if (abstractModel != null) {
                System.out.print(abstractModel.eval(event.getContext())[abstractModel.getIndex(event.getOutcome())] + " ");
            }
            System.out.println(event);
        }
    }
}

