/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.postag;

import chalk.tools.postag.POSSample;
import chalk.tools.util.FilterObjectStream;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WordTagSampleStream
extends FilterObjectStream<String, POSSample> {
    private static Logger logger = Logger.getLogger(WordTagSampleStream.class.getName());

    public WordTagSampleStream(Reader reader) throws IOException {
        super(new PlainTextByLineStream(reader));
    }

    public WordTagSampleStream(ObjectStream<String> objectStream) {
        super(objectStream);
    }

    @Override
    public POSSample read() throws IOException {
        String string = (String)this.samples.read();
        if (string != null) {
            POSSample pOSSample;
            try {
                pOSSample = POSSample.parse(string);
            }
            catch (InvalidFormatException invalidFormatException) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("Error during parsing, ignoring sentence: " + string);
                }
                pOSSample = new POSSample(new String[0], new String[0]);
            }
            return pOSSample;
        }
        return null;
    }
}

