/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.sentdetect;

import chalk.tools.sentdetect.SDContextGenerator;
import chalk.tools.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DefaultSDContextGenerator
implements SDContextGenerator {
    protected StringBuffer buf;
    protected List<String> collectFeats;
    private Set<String> inducedAbbreviations;
    private char[] eosCharacters;

    public DefaultSDContextGenerator(char[] cArray) {
        this(Collections.emptySet(), cArray);
    }

    public DefaultSDContextGenerator(Set<String> set, char[] cArray) {
        this.inducedAbbreviations = set;
        this.eosCharacters = cArray;
        this.buf = new StringBuffer();
        this.collectFeats = new ArrayList<String>();
    }

    @Override
    public String[] getContext(CharSequence charSequence, int n) {
        String string;
        String string2;
        int n2;
        int n3;
        int n4;
        int n5 = charSequence.length() - 1;
        if (n > 0 && StringUtil.isWhitespace(charSequence.charAt(n - 1))) {
            this.collectFeats.add("sp");
        }
        if (n < n5 && StringUtil.isWhitespace(charSequence.charAt(n + 1))) {
            this.collectFeats.add("sn");
        }
        this.collectFeats.add("eos=" + charSequence.charAt(n));
        int n6 = DefaultSDContextGenerator.previousSpaceIndex(charSequence, n);
        int n7 = n;
        block0: while (--n7 > n6) {
            n4 = this.eosCharacters.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (charSequence.charAt(n7) != this.eosCharacters[n3]) continue;
                n6 = n7++;
                continue block0;
            }
        }
        String string3 = new StringBuffer(charSequence.subSequence(n6, n)).toString().trim();
        n3 = DefaultSDContextGenerator.previousSpaceIndex(charSequence, n6);
        String string4 = new StringBuffer(charSequence.subSequence(n3, n6)).toString().trim();
        n4 = DefaultSDContextGenerator.nextSpaceIndex(charSequence, n, n5);
        n7 = n;
        block2: while (++n7 < n4) {
            int n8 = this.eosCharacters.length;
            for (n2 = 0; n2 < n8; ++n2) {
                if (charSequence.charAt(n7) != this.eosCharacters[n2]) continue;
                n4 = n7--;
                continue block2;
            }
        }
        n2 = DefaultSDContextGenerator.nextSpaceIndex(charSequence, n4 + 1, n5 + 1);
        if (n == n5) {
            string2 = "";
            string = "";
        } else {
            string2 = new StringBuilder(charSequence.subSequence(n + 1, n4)).toString().trim();
            string = new StringBuilder(charSequence.subSequence(n4 + 1, n2)).toString().trim();
        }
        this.collectFeatures(string3, string2, string4, string, Character.valueOf(charSequence.charAt(n)));
        String[] stringArray = new String[this.collectFeats.size()];
        stringArray = this.collectFeats.toArray(stringArray);
        this.collectFeats.clear();
        return stringArray;
    }

    protected void collectFeatures(String string, String string2, String string3, String string4) {
        this.collectFeatures(string, string2, string3, string4, null);
    }

    protected void collectFeatures(String string, String string2, String string3, String string4, Character c) {
        this.buf.append("x=");
        this.buf.append(string);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!string.equals("")) {
            this.collectFeats.add(Integer.toString(string.length()));
            if (DefaultSDContextGenerator.isFirstUpper(string)) {
                this.collectFeats.add("xcap");
            }
            if (c != null && this.inducedAbbreviations.contains(string + c)) {
                this.collectFeats.add("xabbrev");
            }
        }
        this.buf.append("v=");
        this.buf.append(string3);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!string3.equals("")) {
            if (DefaultSDContextGenerator.isFirstUpper(string3)) {
                this.collectFeats.add("vcap");
            }
            if (this.inducedAbbreviations.contains(string3)) {
                this.collectFeats.add("vabbrev");
            }
        }
        this.buf.append("s=");
        this.buf.append(string2);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!string2.equals("")) {
            if (DefaultSDContextGenerator.isFirstUpper(string2)) {
                this.collectFeats.add("scap");
            }
            if (this.inducedAbbreviations.contains(string2)) {
                this.collectFeats.add("sabbrev");
            }
        }
        this.buf.append("n=");
        this.buf.append(string4);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!string4.equals("")) {
            if (DefaultSDContextGenerator.isFirstUpper(string4)) {
                this.collectFeats.add("ncap");
            }
            if (this.inducedAbbreviations.contains(string4)) {
                this.collectFeats.add("nabbrev");
            }
        }
    }

    private static final boolean isFirstUpper(String string) {
        return Character.isUpperCase(string.charAt(0));
    }

    private static final int previousSpaceIndex(CharSequence charSequence, int n) {
        --n;
        while (n > 0 && !StringUtil.isWhitespace(charSequence.charAt(n))) {
            --n;
        }
        if (n > 0 && StringUtil.isWhitespace(charSequence.charAt(n))) {
            while (n > 0 && StringUtil.isWhitespace(charSequence.charAt(n - 1))) {
                --n;
            }
            return n;
        }
        return 0;
    }

    private static final int nextSpaceIndex(CharSequence charSequence, int n, int n2) {
        ++n;
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (StringUtil.isWhitespace(c)) {
                while (charSequence.length() > n + 1 && StringUtil.isWhitespace(charSequence.charAt(n + 1))) {
                    ++n;
                }
                return n;
            }
            ++n;
        }
        return n2;
    }
}

