/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.sentdetect;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.sentdetect.SentenceDetectorEvaluationMonitor;
import chalk.tools.sentdetect.SentenceDetectorEvaluator;
import chalk.tools.sentdetect.SentenceDetectorFactory;
import chalk.tools.sentdetect.SentenceDetectorME;
import chalk.tools.sentdetect.SentenceModel;
import chalk.tools.sentdetect.SentenceSample;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.eval.CrossValidationPartitioner;
import chalk.tools.util.eval.FMeasure;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;

public class SDCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private FMeasure fmeasure = new FMeasure();
    private SentenceDetectorEvaluationMonitor[] listeners;
    private SentenceDetectorFactory sdFactory;

    public SDCrossValidator(String string, TrainingParameters trainingParameters, SentenceDetectorFactory sentenceDetectorFactory, SentenceDetectorEvaluationMonitor ... sentenceDetectorEvaluationMonitorArray) {
        this.languageCode = string;
        this.params = trainingParameters;
        this.listeners = sentenceDetectorEvaluationMonitorArray;
        this.sdFactory = sentenceDetectorFactory;
    }

    public SDCrossValidator(String string, int n, int n2) {
        this(string, ModelUtil.createTrainingParameters(n, n2));
    }

    public SDCrossValidator(String string, TrainingParameters trainingParameters) {
        this(string, trainingParameters, new SentenceDetectorFactory(string, true, null, null), new SentenceDetectorEvaluationMonitor[0]);
    }

    @Deprecated
    public SDCrossValidator(String string, int n, int n2, Dictionary dictionary) {
        this(string, ModelUtil.createTrainingParameters(n, n2), new SentenceDetectorFactory(string, true, dictionary, null), new SentenceDetectorEvaluationMonitor[0]);
    }

    public SDCrossValidator(String string, TrainingParameters trainingParameters, SentenceDetectorEvaluationMonitor ... sentenceDetectorEvaluationMonitorArray) {
        this(string, trainingParameters, new SentenceDetectorFactory(string, true, null, null), sentenceDetectorEvaluationMonitorArray);
    }

    public SDCrossValidator(String string) {
        this(string, 5, 100);
    }

    public void evaluate(ObjectStream<SentenceSample> objectStream, int n) throws IOException {
        CrossValidationPartitioner<SentenceSample> crossValidationPartitioner = new CrossValidationPartitioner<SentenceSample>(objectStream, n);
        while (crossValidationPartitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<SentenceSample> trainingSampleStream = crossValidationPartitioner.next();
            SentenceModel sentenceModel = SentenceDetectorME.train(this.languageCode, trainingSampleStream, this.sdFactory, this.params);
            SentenceDetectorEvaluator sentenceDetectorEvaluator = new SentenceDetectorEvaluator(new SentenceDetectorME(sentenceModel), this.listeners);
            sentenceDetectorEvaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(sentenceDetectorEvaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

