/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.sentdetect;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.sentdetect.SentenceDetectorFactory;
import chalk.tools.util.BaseToolFactory;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.model.BaseModel;
import chalk.tools.util.model.ModelUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import nak.model.AbstractModel;
import nak.model.GenericModelReader;
import nak.model.MaxentModel;

public class SentenceModel
extends BaseModel {
    private static final String COMPONENT_NAME = "SentenceDetectorME";
    private static final String MAXENT_MODEL_ENTRY_NAME = "sent.model";

    public SentenceModel(String string, AbstractModel abstractModel, Map<String, String> map, SentenceDetectorFactory sentenceDetectorFactory) {
        super(COMPONENT_NAME, string, map, sentenceDetectorFactory);
        this.artifactMap.put(MAXENT_MODEL_ENTRY_NAME, abstractModel);
        this.checkArtifactMap();
    }

    public SentenceModel(String string, AbstractModel abstractModel, boolean bl, Dictionary dictionary, char[] cArray, Map<String, String> map) {
        this(string, abstractModel, map, new SentenceDetectorFactory(string, bl, dictionary, cArray));
    }

    public SentenceModel(String string, AbstractModel abstractModel, boolean bl, Dictionary dictionary, char[] cArray) {
        this(string, abstractModel, bl, dictionary, cArray, null);
    }

    public SentenceModel(String string, AbstractModel abstractModel, boolean bl, Dictionary dictionary, Map<String, String> map) {
        this(string, abstractModel, bl, dictionary, null, map);
    }

    public SentenceModel(String string, AbstractModel abstractModel, boolean bl, Dictionary dictionary) {
        this(string, abstractModel, bl, dictionary, null, null);
    }

    public SentenceModel(InputStream inputStream) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, inputStream);
    }

    public SentenceModel(File file) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, file);
    }

    public SentenceModel(URL uRL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, uRL);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Unable to find sent.model maxent model!");
        }
        if (!ModelUtil.validateOutcomes((MaxentModel)this.getMaxentModel(), "s", "n")) {
            throw new InvalidFormatException("The maxent model is not compatible with the sentence detector!");
        }
    }

    public SentenceDetectorFactory getFactory() {
        return (SentenceDetectorFactory)this.toolFactory;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return SentenceDetectorFactory.class;
    }

    public AbstractModel getMaxentModel() {
        return (AbstractModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
    }

    public Dictionary getAbbreviations() {
        if (this.getFactory() != null) {
            return this.getFactory().getAbbreviationDictionary();
        }
        return null;
    }

    public boolean useTokenEnd() {
        if (this.getFactory() != null) {
            return this.getFactory().isUseTokenEnd();
        }
        return true;
    }

    public char[] getEosCharacters() {
        if (this.getFactory() != null) {
            return this.getFactory().getEOSCharacters();
        }
        return null;
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, InvalidFormatException {
        if (stringArray.length < 3) {
            System.err.println("SentenceModel [-abbreviationsDictionary] [-useTokenEnd] languageCode packageName modelName");
            System.exit(1);
        }
        int n = 0;
        Dictionary dictionary = null;
        if ("-abbreviationsDictionary".equals(stringArray[n])) {
            int n2 = ++n;
            ++n;
            dictionary = new Dictionary(new FileInputStream(stringArray[n2]));
        }
        boolean bl = false;
        if ("-useTokenEnd".equals(stringArray[n])) {
            bl = true;
        }
        int n3 = ++n;
        String string = stringArray[n3];
        int n4 = ++n;
        String string2 = stringArray[n4];
        String string3 = stringArray[++n];
        AbstractModel abstractModel = new GenericModelReader(new File(string3)).getModel();
        SentenceModel sentenceModel = new SentenceModel(string, abstractModel, bl, dictionary, (char[])null);
        sentenceModel.serialize(new FileOutputStream(string2));
    }
}

