/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.sentdetect;

import chalk.tools.tokenize.Detokenizer;
import chalk.tools.util.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SentenceSample {
    private final String document;
    private final List<Span> sentences;

    public SentenceSample(String string, Span ... spanArray) {
        this.document = string;
        this.sentences = Collections.unmodifiableList(new ArrayList<Span>(Arrays.asList(spanArray)));
    }

    public SentenceSample(Detokenizer detokenizer, String[][] stringArray) {
        ArrayList<Span> arrayList = new ArrayList<Span>(stringArray.length);
        StringBuilder stringBuilder = new StringBuilder();
        for (String[] stringArray2 : stringArray) {
            String string = detokenizer.detokenize(stringArray2, null);
            int n = stringBuilder.length();
            stringBuilder.append(string);
            arrayList.add(new Span(n, stringBuilder.length()));
        }
        this.document = stringBuilder.toString();
        this.sentences = Collections.unmodifiableList(arrayList);
    }

    public String getDocument() {
        return this.document;
    }

    public Span[] getSentences() {
        return this.sentences.toArray(new Span[this.sentences.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Span span : this.sentences) {
            stringBuilder.append(span.getCoveredText(this.document));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SentenceSample) {
            SentenceSample sentenceSample = (SentenceSample)object;
            return this.getDocument().equals(sentenceSample.getDocument()) && Arrays.equals(this.getSentences(), sentenceSample.getSentences());
        }
        return false;
    }
}

