/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize;

import chalk.tools.tokenize.TokenContextGenerator;
import chalk.tools.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DefaultTokenContextGenerator
implements TokenContextGenerator {
    protected final Set<String> inducedAbbreviations;

    public DefaultTokenContextGenerator() {
        this(Collections.emptySet());
    }

    public DefaultTokenContextGenerator(Set<String> set) {
        this.inducedAbbreviations = set;
    }

    @Override
    public String[] getContext(String string, int n) {
        List<String> list = this.createContext(string, n);
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    protected List<String> createContext(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        arrayList.add("p=" + string2);
        arrayList.add("s=" + string3);
        if (n > 0) {
            this.addCharPreds("p1", string.charAt(n - 1), arrayList);
            if (n > 1) {
                this.addCharPreds("p2", string.charAt(n - 2), arrayList);
                arrayList.add("p21=" + string.charAt(n - 2) + string.charAt(n - 1));
            } else {
                arrayList.add("p2=bok");
            }
            arrayList.add("p1f1=" + string.charAt(n - 1) + string.charAt(n));
        } else {
            arrayList.add("p1=bok");
        }
        this.addCharPreds("f1", string.charAt(n), arrayList);
        if (n + 1 < string.length()) {
            this.addCharPreds("f2", string.charAt(n + 1), arrayList);
            arrayList.add("f12=" + string.charAt(n) + string.charAt(n + 1));
        } else {
            arrayList.add("f2=bok");
        }
        if (string.charAt(0) == '&' && string.charAt(string.length() - 1) == ';') {
            arrayList.add("cc");
        }
        if (n == string.length() - 1 && this.inducedAbbreviations.contains(string)) {
            arrayList.add("pabb");
        }
        return arrayList;
    }

    protected void addCharPreds(String string, char c, List<String> list) {
        list.add(string + "=" + c);
        if (Character.isLetter(c)) {
            list.add(string + "_alpha");
            if (Character.isUpperCase(c)) {
                list.add(string + "_caps");
            }
        } else if (Character.isDigit(c)) {
            list.add(string + "_num");
        } else if (StringUtil.isWhitespace(c)) {
            list.add(string + "_ws");
        } else if (c == '.' || c == '?' || c == '!') {
            list.add(string + "_eos");
        } else if (c == '`' || c == '\"' || c == '\'') {
            list.add(string + "_quote");
        } else if (c == '[' || c == '{' || c == '(') {
            list.add(string + "_lp");
        } else if (c == ']' || c == '}' || c == ')') {
            list.add(string + "_rp");
        }
    }
}

