/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.tokenize.TokenSample;
import chalk.tools.tokenize.TokenizerEvaluationMonitor;
import chalk.tools.tokenize.TokenizerEvaluator;
import chalk.tools.tokenize.TokenizerFactory;
import chalk.tools.tokenize.TokenizerME;
import chalk.tools.tokenize.TokenizerModel;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.eval.CrossValidationPartitioner;
import chalk.tools.util.eval.FMeasure;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;

public class TokenizerCrossValidator {
    private final TrainingParameters params;
    private FMeasure fmeasure = new FMeasure();
    private TokenizerEvaluationMonitor[] listeners;
    private final TokenizerFactory factory;

    public TokenizerCrossValidator(TrainingParameters trainingParameters, TokenizerFactory tokenizerFactory, TokenizerEvaluationMonitor ... tokenizerEvaluationMonitorArray) {
        this.params = trainingParameters;
        this.listeners = tokenizerEvaluationMonitorArray;
        this.factory = tokenizerFactory;
    }

    public TokenizerCrossValidator(String string, Dictionary dictionary, boolean bl, TrainingParameters trainingParameters, TokenizerEvaluationMonitor ... tokenizerEvaluationMonitorArray) {
        this(trainingParameters, new TokenizerFactory(string, dictionary, bl, null), tokenizerEvaluationMonitorArray);
    }

    public TokenizerCrossValidator(String string, boolean bl, int n, int n2) {
        this(string, bl, ModelUtil.createTrainingParameters(n2, n), new TokenizerEvaluationMonitor[0]);
    }

    public TokenizerCrossValidator(String string, boolean bl) {
        this(string, bl, ModelUtil.createTrainingParameters(100, 5), new TokenizerEvaluationMonitor[0]);
    }

    public TokenizerCrossValidator(String string, boolean bl, TrainingParameters trainingParameters, TokenizerEvaluationMonitor ... tokenizerEvaluationMonitorArray) {
        this(string, null, bl, trainingParameters, tokenizerEvaluationMonitorArray);
    }

    public void evaluate(ObjectStream<TokenSample> objectStream, int n) throws IOException {
        CrossValidationPartitioner<TokenSample> crossValidationPartitioner = new CrossValidationPartitioner<TokenSample>(objectStream, n);
        while (crossValidationPartitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<TokenSample> trainingSampleStream = crossValidationPartitioner.next();
            TokenizerModel tokenizerModel = TokenizerME.train(trainingSampleStream, this.factory, this.params);
            TokenizerEvaluator tokenizerEvaluator = new TokenizerEvaluator(new TokenizerME(tokenizerModel), this.listeners);
            tokenizerEvaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(tokenizerEvaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

