/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.tokenize.TokenContextGenerator;
import chalk.tools.tokenize.lang.Factory;
import chalk.tools.util.BaseToolFactory;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ext.ExtensionLoader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class TokenizerFactory
extends BaseToolFactory {
    private String languageCode;
    private Dictionary abbreviationDictionary;
    private Boolean useAlphaNumericOptimization = null;
    private Pattern alphaNumericPattern;
    private static final String ABBREVIATIONS_ENTRY_NAME = "abbreviations.dictionary";
    private static final String USE_ALPHA_NUMERIC_OPTIMIZATION = "useAlphaNumericOptimization";
    private static final String ALPHA_NUMERIC_PATTERN = "alphaNumericPattern";

    public TokenizerFactory() {
    }

    public TokenizerFactory(String string, Dictionary dictionary, boolean bl, Pattern pattern) {
        this.init(string, dictionary, bl, pattern);
    }

    protected void init(String string, Dictionary dictionary, boolean bl, Pattern pattern) {
        this.languageCode = string;
        this.useAlphaNumericOptimization = bl;
        this.alphaNumericPattern = pattern;
        this.abbreviationDictionary = dictionary;
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
        if (this.artifactProvider.getManifestProperty(USE_ALPHA_NUMERIC_OPTIMIZATION) == null) {
            throw new InvalidFormatException("useAlphaNumericOptimization is a mandatory property!");
        }
        Object t = this.artifactProvider.getArtifact(ABBREVIATIONS_ENTRY_NAME);
        if (t != null && !(t instanceof Dictionary)) {
            throw new InvalidFormatException("Abbreviations dictionary '" + t + "' has wrong type, needs to be of type Dictionary!");
        }
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> map = super.createArtifactMap();
        if (this.abbreviationDictionary != null) {
            map.put(ABBREVIATIONS_ENTRY_NAME, this.abbreviationDictionary);
        }
        return map;
    }

    @Override
    public Map<String, String> createManifestEntries() {
        Map<String, String> map = super.createManifestEntries();
        map.put(USE_ALPHA_NUMERIC_OPTIMIZATION, Boolean.toString(this.isUseAlphaNumericOptmization()));
        if (this.getAlphaNumericPattern() != null) {
            map.put(ALPHA_NUMERIC_PATTERN, this.getAlphaNumericPattern().pattern());
        }
        return map;
    }

    public static TokenizerFactory create(String string, String string2, Dictionary dictionary, boolean bl, Pattern pattern) throws InvalidFormatException {
        if (string == null) {
            return new TokenizerFactory(string2, dictionary, bl, pattern);
        }
        try {
            TokenizerFactory tokenizerFactory = ExtensionLoader.instantiateExtension(TokenizerFactory.class, string);
            tokenizerFactory.init(string2, dictionary, bl, pattern);
            return tokenizerFactory;
        }
        catch (Exception exception) {
            String string3 = "Could not instantiate the " + string + ". The initialization throw an exception.";
            System.err.println(string3);
            exception.printStackTrace();
            throw new InvalidFormatException(string3, exception);
        }
    }

    public Pattern getAlphaNumericPattern() {
        if (this.alphaNumericPattern == null) {
            Object object;
            if (this.artifactProvider != null && (object = this.artifactProvider.getManifestProperty(ALPHA_NUMERIC_PATTERN)) != null) {
                this.alphaNumericPattern = Pattern.compile((String)object);
            }
            if (this.alphaNumericPattern == null) {
                object = new Factory();
                this.alphaNumericPattern = ((Factory)object).getAlphanumeric(this.languageCode);
            }
        }
        return this.alphaNumericPattern;
    }

    public boolean isUseAlphaNumericOptmization() {
        if (this.useAlphaNumericOptimization == null && this.artifactProvider != null) {
            this.useAlphaNumericOptimization = Boolean.valueOf(this.artifactProvider.getManifestProperty(USE_ALPHA_NUMERIC_OPTIMIZATION));
        }
        return this.useAlphaNumericOptimization;
    }

    public Dictionary getAbbreviationDictionary() {
        if (this.abbreviationDictionary == null && this.artifactProvider != null) {
            this.abbreviationDictionary = (Dictionary)this.artifactProvider.getArtifact(ABBREVIATIONS_ENTRY_NAME);
        }
        return this.abbreviationDictionary;
    }

    public String getLanguageCode() {
        if (this.languageCode == null && this.artifactProvider != null) {
            this.languageCode = this.artifactProvider.getLanguage();
        }
        return this.languageCode;
    }

    public TokenContextGenerator getContextGenerator() {
        Factory factory = new Factory();
        Set<String> set = null;
        Dictionary dictionary = this.getAbbreviationDictionary();
        set = dictionary != null ? dictionary.asStringSet() : Collections.emptySet();
        return factory.createTokenContextGenerator(this.getLanguageCode(), set);
    }
}

