/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.tokenize.lang.en;

import chalk.tools.tokenize.TokenSample;
import chalk.tools.util.Span;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public class TokenSampleStream
implements Iterator<TokenSample> {
    private BufferedReader in;
    private String line;
    private Pattern alphaNumeric = Pattern.compile("[A-Za-z0-9]");
    private boolean evenq = true;

    public TokenSampleStream(InputStream inputStream) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(inputStream));
        this.line = this.in.readLine();
    }

    @Override
    public boolean hasNext() {
        return this.line != null;
    }

    @Override
    public TokenSample next() {
        String[] stringArray = this.line.split("\\s+");
        if (stringArray.length == 0) {
            this.evenq = true;
        }
        StringBuilder stringBuilder = new StringBuilder(this.line.length());
        ArrayList<Span> arrayList = new ArrayList<Span>();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            String string3 = string = i - 1 >= 0 ? stringArray[i - 1] : "";
            if (string2.equals("-LRB-")) {
                string2 = "(";
            } else if (string2.equals("-LCB-")) {
                string2 = "{";
            } else if (string2.equals("-RRB-")) {
                string2 = ")";
            } else if (string2.equals("-RCB-")) {
                string2 = "}";
            }
            if (stringBuilder.length() != 0) {
                if (!this.alphaNumeric.matcher(string2).find() || string2.startsWith("'") || string2.equalsIgnoreCase("n't")) {
                    if ((string2.equals("``") || string2.equals("--") || string2.equals("$") || string2.equals("(") || string2.equals("&") || string2.equals("#") || string2.equals("\"") && this.evenq && i != stringArray.length - 1) && (!string.equals("(") || !string.equals("{"))) {
                        ++n;
                    }
                } else if (!(string.equals("``") || string.equals("\"") && !this.evenq || string.equals("(") || string.equals("{") || string.equals("$") || string.equals("#"))) {
                    ++n;
                }
            }
            if (string2.equals("\"")) {
                if (i == stringArray.length - 1) {
                    this.evenq = true;
                } else {
                    boolean bl = this.evenq = !this.evenq;
                }
            }
            if (stringBuilder.length() < n) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string2);
            arrayList.add(new Span(n, n + string2.length()));
            n += string2.length();
        }
        try {
            this.line = this.in.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.line = null;
        }
        return new TokenSample(stringBuilder.toString(), arrayList.toArray(new Span[arrayList.size()]));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static void usage() {
        System.err.println("TokenSampleStream [-spans] < in");
        System.err.println("Where in is a space delimited list of tokens.");
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-spans")) {
                bl = true;
                continue;
            }
            System.err.println("Unknown option " + stringArray[i]);
            TokenSampleStream.usage();
        }
        TokenSampleStream tokenSampleStream = new TokenSampleStream(System.in);
        while (tokenSampleStream.hasNext()) {
            TokenSample tokenSample = tokenSampleStream.next();
            String string = tokenSample.getText();
            System.out.println(string);
            Span[] spanArray = tokenSample.getTokenSpans();
            int n = 0;
            if (!bl) continue;
            for (int i = 0; i < string.length(); ++i) {
                if (n - 1 >= 0 && i == spanArray[n - 1].getEnd() - 1) {
                    System.out.print("]");
                    continue;
                }
                if (i == spanArray[n].getStart()) {
                    if (++n - 1 >= 0 && i == spanArray[n - 1].getEnd() - 1) {
                        System.out.print("|");
                        continue;
                    }
                    System.out.print("[");
                    continue;
                }
                System.out.print("-");
            }
            System.out.println();
        }
    }
}

