/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ext.ExtensionLoader;
import chalk.tools.util.model.ArtifactProvider;
import chalk.tools.util.model.ArtifactSerializer;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseToolFactory {
    protected ArtifactProvider artifactProvider;

    protected void init(ArtifactProvider artifactProvider) {
        this.artifactProvider = artifactProvider;
    }

    public Map<String, ArtifactSerializer> createArtifactSerializersMap() {
        return new HashMap<String, ArtifactSerializer>();
    }

    public Map<String, Object> createArtifactMap() {
        return new HashMap<String, Object>();
    }

    public Map<String, String> createManifestEntries() {
        return new HashMap<String, String>();
    }

    public abstract void validateArtifactMap() throws InvalidFormatException;

    public static BaseToolFactory create(String string, ArtifactProvider artifactProvider) throws InvalidFormatException {
        BaseToolFactory baseToolFactory = null;
        try {
            baseToolFactory = ExtensionLoader.instantiateExtension(BaseToolFactory.class, string);
            if (baseToolFactory != null) {
                baseToolFactory.init(artifactProvider);
            }
        }
        catch (Exception exception) {
            String string2 = "Could not instantiate the " + string + ". The initialization throw an exception.";
            System.err.println(string2);
            exception.printStackTrace();
            throw new InvalidFormatException(string2, exception);
        }
        return baseToolFactory;
    }

    public static BaseToolFactory create(Class<? extends BaseToolFactory> clazz, ArtifactProvider artifactProvider) throws InvalidFormatException {
        BaseToolFactory baseToolFactory = null;
        if (clazz != null) {
            try {
                baseToolFactory = clazz.newInstance();
                baseToolFactory.init(artifactProvider);
            }
            catch (Exception exception) {
                String string = "Could not instantiate the " + clazz.getCanonicalName() + ". The initialization throw an exception.";
                System.err.println(string);
                exception.printStackTrace();
                throw new InvalidFormatException(string, exception);
            }
        }
        return baseToolFactory;
    }
}

