/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

import chalk.tools.util.BeamSearchContextGenerator;
import chalk.tools.util.Cache;
import chalk.tools.util.ListHeap;
import chalk.tools.util.Sequence;
import chalk.tools.util.SequenceValidator;
import java.util.Arrays;
import java.util.List;
import nak.model.MaxentModel;

public class BeamSearch<T> {
    private static final Object[] EMPTY_ADDITIONAL_CONTEXT = new Object[0];
    protected int size;
    protected BeamSearchContextGenerator<T> cg;
    protected MaxentModel model;
    private SequenceValidator<T> validator;
    private double[] probs;
    private Cache contextsCache;
    private static final int zeroLog = -100000;

    public BeamSearch(int n, BeamSearchContextGenerator<T> beamSearchContextGenerator, MaxentModel maxentModel) {
        this(n, beamSearchContextGenerator, maxentModel, null, 0);
    }

    public BeamSearch(int n, BeamSearchContextGenerator<T> beamSearchContextGenerator, MaxentModel maxentModel, int n2) {
        this(n, beamSearchContextGenerator, maxentModel, null, n2);
    }

    public BeamSearch(int n, BeamSearchContextGenerator<T> beamSearchContextGenerator, MaxentModel maxentModel, SequenceValidator<T> sequenceValidator, int n2) {
        this.size = n;
        this.cg = beamSearchContextGenerator;
        this.model = maxentModel;
        this.validator = sequenceValidator;
        if (n2 > 0) {
            this.contextsCache = new Cache(n2);
        }
        this.probs = new double[maxentModel.getNumOutcomes()];
    }

    private boolean validSequence(int n, T[] TArray, String[] stringArray, String string) {
        if (this.validator != null) {
            return this.validator.validSequence(n, TArray, stringArray, string);
        }
        return true;
    }

    public Sequence[] bestSequences(int n, T[] TArray, Object[] objectArray) {
        return this.bestSequences(n, TArray, objectArray, -100000.0);
    }

    public Sequence[] bestSequences(int n, T[] TArray, Object[] objectArray, double d) {
        int n2;
        int n3;
        ListHeap<Sequence> listHeap = new ListHeap<Sequence>(this.size);
        ListHeap<Sequence> listHeap2 = new ListHeap<Sequence>(this.size);
        listHeap.add(new Sequence());
        if (objectArray == null) {
            objectArray = EMPTY_ADDITIONAL_CONTEXT;
        }
        for (n3 = 0; n3 < TArray.length; ++n3) {
            int n4 = Math.min(this.size, listHeap.size());
            for (n2 = 0; listHeap.size() > 0 && n2 < n4; ++n2) {
                Sequence sequence;
                String string;
                int n5;
                double[] dArray;
                Sequence sequence2 = (Sequence)listHeap.extract();
                List<String> list = sequence2.getOutcomes();
                String[] stringArray = list.toArray(new String[list.size()]);
                String[] stringArray2 = this.cg.getContext(n3, TArray, stringArray, objectArray);
                if (this.contextsCache != null) {
                    dArray = (double[])this.contextsCache.get(stringArray2);
                    if (dArray == null) {
                        dArray = this.model.eval(stringArray2, this.probs);
                        this.contextsCache.put(stringArray2, dArray);
                    }
                } else {
                    dArray = this.model.eval(stringArray2, this.probs);
                }
                double[] dArray2 = new double[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray2[i] = dArray[i];
                }
                Arrays.sort(dArray2);
                double d2 = dArray2[Math.max(0, dArray.length - this.size)];
                for (n5 = 0; n5 < dArray.length; ++n5) {
                    if (dArray[n5] < d2 || !this.validSequence(n3, TArray, stringArray, string = this.model.getOutcome(n5)) || !((sequence = new Sequence(sequence2, string, dArray[n5])).getScore() > d)) continue;
                    listHeap2.add(sequence);
                }
                if (listHeap2.size() != 0) continue;
                for (n5 = 0; n5 < dArray.length; ++n5) {
                    string = this.model.getOutcome(n5);
                    if (!this.validSequence(n3, TArray, stringArray, string) || !((sequence = new Sequence(sequence2, string, dArray[n5])).getScore() > d)) continue;
                    listHeap2.add(sequence);
                }
            }
            listHeap.clear();
            ListHeap<Sequence> listHeap3 = listHeap;
            listHeap = listHeap2;
            listHeap2 = listHeap3;
        }
        n3 = Math.min(n, listHeap.size());
        Sequence[] sequenceArray = new Sequence[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            sequenceArray[n2] = (Sequence)listHeap.extract();
        }
        return sequenceArray;
    }

    public Sequence bestSequence(T[] TArray, Object[] objectArray) {
        Sequence[] sequenceArray = this.bestSequences(1, TArray, objectArray, -100000.0);
        if (sequenceArray.length > 0) {
            return sequenceArray[0];
        }
        return null;
    }
}

