/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CountedSet<E>
implements Set<E> {
    private Map<E, Integer> cset;

    public CountedSet() {
        this.cset = new HashMap<E, Integer>();
    }

    public CountedSet(int n) {
        this.cset = new HashMap<E, Integer>(n);
    }

    @Override
    public boolean add(E e) {
        Integer n = this.cset.get(e);
        if (n == null) {
            this.cset.put(e, 1);
            return true;
        }
        this.cset.put(e, n + 1);
        return false;
    }

    public void subtract(E e) {
        Integer n = this.cset.get(e);
        if (n != null) {
            int n2 = n - 1;
            if (n2 == 0) {
                this.cset.remove(e);
            } else {
                this.cset.put(e, n2);
            }
        }
    }

    public void setCount(E e, int n) {
        this.cset.put(e, n);
    }

    public int getCount(E e) {
        Integer n = this.cset.get(e);
        if (n == null) {
            return 0;
        }
        return n;
    }

    @Deprecated
    public void write(String string, int n) {
        this.write(string, n, " ");
    }

    @Deprecated
    public void write(String string, int n, String string2) {
        this.write(string, n, string2, null);
    }

    @Deprecated
    public void write(String string, int n, String string2, String string3) {
        PrintWriter printWriter = null;
        try {
            printWriter = string3 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string3)) : new PrintWriter(new FileWriter(string));
            for (E e : this.cset.keySet()) {
                int n2 = this.getCount(e);
                if (n2 < n) continue;
                printWriter.println(n2 + string2 + e);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            bl = bl || this.add(e);
        }
        return bl;
    }

    @Override
    public void clear() {
        this.cset.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.cset.keySet().contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.cset.keySet().containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.cset.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.cset.keySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.cset.remove(object) != null;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.cset.keySet().iterator();
        while (iterator.hasNext()) {
            bl = bl || this.cset.remove(iterator.next()) != null;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        for (E e : this.cset.keySet()) {
            if (collection.contains(e)) continue;
            this.cset.remove(e);
            bl = true;
        }
        return bl;
    }

    @Override
    public int size() {
        return this.cset.size();
    }

    @Override
    public Object[] toArray() {
        return this.cset.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.cset.keySet().toArray(TArray);
    }
}

