/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StringList
implements Iterable<String> {
    private String[] tokens;

    public StringList(String string) {
        this.tokens = new String[]{string.intern()};
    }

    public StringList(String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("tokens must not be null");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("tokens must not be empty");
        }
        this.tokens = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.tokens[i] = stringArray[i].intern();
        }
    }

    public String getToken(int n) {
        return this.tokens[n];
    }

    public int size() {
        return this.tokens.length;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < StringList.this.size();
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    return StringList.this.getToken(this.index++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean compareToIgnoreCase(StringList stringList) {
        if (this.size() == stringList.size()) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.getToken(i).compareToIgnoreCase(stringList.getToken(i)) == 0) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            bl = true;
        } else if (object instanceof StringList) {
            StringList stringList = (StringList)object;
            bl = Arrays.equals(this.tokens, stringList.tokens);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        int n = 32 / this.size();
        int n2 = 32 % this.size();
        int n3 = -1 >>> 32 - n + 1;
        int n4 = -1 >>> 32 - n;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < this.size(); ++i) {
            int n7;
            int n8;
            if (i < n2) {
                n8 = n3;
                n7 = n + 1;
            } else {
                n8 = n4;
                n7 = n;
            }
            int n9 = this.getToken(i).hashCode() & n8;
            n5 |= (n9 <<= 32 - (n6 += n7) - n7);
        }
        return n5;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < this.size(); ++i) {
            stringBuilder.append(this.getToken(i));
            if (i >= this.size() - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

