/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TrainingParameters {
    public static final String ALGORITHM_PARAM = "Algorithm";
    public static final String ITERATIONS_PARAM = "Iterations";
    public static final String CUTOFF_PARAM = "Cutoff";
    private Map<String, String> parameters = new HashMap<String, String>();

    public TrainingParameters() {
    }

    public TrainingParameters(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.parameters.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public String algorithm(String string) {
        return this.parameters.get(string + "." + ALGORITHM_PARAM);
    }

    public String algorithm() {
        return this.parameters.get(ALGORITHM_PARAM);
    }

    public Map<String, String> getSettings(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String string2 = entry.getKey();
            if (string != null) {
                String string3 = string + ".";
                if (!string2.startsWith(string3)) continue;
                hashMap.put(string2.substring(string3.length()), entry.getValue());
                continue;
            }
            if (string2.contains(".")) continue;
            hashMap.put(string2, entry.getValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Map<String, String> getSettings() {
        return this.getSettings(null);
    }

    public TrainingParameters getParameters(String string) {
        TrainingParameters trainingParameters = new TrainingParameters();
        for (Map.Entry<String, String> entry : this.getSettings(string).entrySet()) {
            trainingParameters.put(entry.getKey(), entry.getValue());
        }
        return trainingParameters;
    }

    public void put(String string, String string2, String string3) {
        if (string == null) {
            this.parameters.put(string2, string3);
        } else {
            this.parameters.put(string + "." + string2, string3);
        }
    }

    public void put(String string, String string2) {
        this.put(null, string, string2);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        properties.store(outputStream, null);
    }

    public static final TrainingParameters defaultParams() {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put(ALGORITHM_PARAM, "MAXENT");
        trainingParameters.put(ITERATIONS_PARAM, Integer.toString(100));
        trainingParameters.put(CUTOFF_PARAM, Integer.toString(5));
        return trainingParameters;
    }
}

