/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Version {
    private static final String DEV_VERSION_STRING = "0.0.0-SNAPSHOT";
    public static final Version DEV_VERSION = Version.parse("0.0.0-SNAPSHOT");
    private static final String SNAPSHOT_MARKER = "-SNAPSHOT";
    private final int major;
    private final int minor;
    private final int revision;
    private final boolean snapshot;

    public Version(int n, int n2, int n3, boolean bl) {
        this.major = n;
        this.minor = n2;
        this.revision = n3;
        this.snapshot = bl;
    }

    public Version(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        return Integer.toString(this.getMajor()) + "." + Integer.toString(this.getMinor()) + "." + Integer.toString(this.getRevision()) + (this.isSnapshot() ? SNAPSHOT_MARKER : "");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Version) {
            Version version = (Version)object;
            return this.getMajor() == version.getMajor() && this.getMinor() == version.getMinor() && this.getRevision() == version.getRevision() && this.isSnapshot() == version.isSnapshot();
        }
        return false;
    }

    public static Version parse(String string) {
        int n = string.indexOf(46);
        int n2 = string.indexOf(46, n + 1);
        if (n == -1 || n2 == -1) {
            throw new NumberFormatException("Invalid version format '" + string + "', expected two dots!");
        }
        int n3 = string.indexOf(45);
        int n4 = n3 == -1 ? string.length() : n3;
        boolean bl = string.endsWith(SNAPSHOT_MARKER);
        return new Version(Integer.parseInt(string.substring(0, n)), Integer.parseInt(string.substring(n + 1, n2)), Integer.parseInt(string.substring(n2 + 1, n4)), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version currentVersion() {
        String string;
        Properties properties = new Properties();
        InputStream inputStream = Version.class.getResourceAsStream("opennlp.version");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if ((string = properties.getProperty("OpenNLP-Version", DEV_VERSION_STRING)).equals("${pom.version}")) {
            string = DEV_VERSION_STRING;
        }
        return Version.parse(string);
    }
}

