/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.eval;

import chalk.tools.util.ObjectStream;
import chalk.tools.util.eval.EvaluationMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Evaluator<T> {
    private List<EvaluationMonitor<T>> listeners;

    public Evaluator(EvaluationMonitor<T> ... evaluationMonitorArray) {
        if (evaluationMonitorArray != null) {
            ArrayList<EvaluationMonitor<T>> arrayList = new ArrayList<EvaluationMonitor<T>>(evaluationMonitorArray.length);
            for (EvaluationMonitor<T> evaluationMonitor : evaluationMonitorArray) {
                if (evaluationMonitor == null) continue;
                arrayList.add(evaluationMonitor);
            }
            this.listeners = Collections.unmodifiableList(arrayList);
        } else {
            this.listeners = Collections.emptyList();
        }
    }

    protected T processSample(T t) {
        return null;
    }

    public void evaluateSample(T t) {
        block4: {
            T t2 = this.processSample(t);
            if (this.listeners.isEmpty()) break block4;
            if (t.equals(t2)) {
                for (EvaluationMonitor<T> evaluationMonitor : this.listeners) {
                    evaluationMonitor.correctlyClassified(t2, t2);
                }
            } else {
                for (EvaluationMonitor<T> evaluationMonitor : this.listeners) {
                    evaluationMonitor.missclassified(t, t2);
                }
            }
        }
    }

    public void evaluate(ObjectStream<T> objectStream) throws IOException {
        T t;
        while ((t = objectStream.read()) != null) {
            this.evaluateSample(t);
        }
    }
}

