/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.ext;

import chalk.tools.util.ext.ExtensionLoader;
import chalk.tools.util.ext.ExtensionNotLoadedException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiExtensionLoader
implements BundleActivator {
    private static OSGiExtensionLoader instance;
    private BundleContext context;

    public void start(BundleContext bundleContext) throws Exception {
        instance = this;
        this.context = bundleContext;
        ExtensionLoader.setOSGiAvailable();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        instance = null;
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T getExtension(Class<T> clazz, String string) {
        Filter filter;
        if (this.context == null) {
            throw new IllegalStateException("OpenNLP Tools Bundle is not active!");
        }
        try {
            filter = FrameworkUtil.createFilter((String)("(&(objectclass=" + clazz.getName() + ")(" + "opennlp" + "=" + string + "))"));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new ExtensionNotLoadedException(invalidSyntaxException);
        }
        ServiceTracker serviceTracker = new ServiceTracker(this.context, filter, null);
        Object object = null;
        try {
            serviceTracker.open();
            try {
                object = serviceTracker.waitForService(30000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            serviceTracker.close();
        }
        if (object == null) {
            throw new ExtensionNotLoadedException("No suitable extension found. Extension name: " + string);
        }
        return (T)object;
    }

    static OSGiExtensionLoader getInstance() {
        return instance;
    }
}

