/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.featuregen;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ext.ExtensionLoader;
import chalk.tools.util.featuregen.AdaptiveFeatureGenerator;
import chalk.tools.util.featuregen.AggregatedFeatureGenerator;
import chalk.tools.util.featuregen.BigramNameFeatureGenerator;
import chalk.tools.util.featuregen.CachedFeatureGenerator;
import chalk.tools.util.featuregen.CharacterNgramFeatureGenerator;
import chalk.tools.util.featuregen.DictionaryFeatureGenerator;
import chalk.tools.util.featuregen.FeatureGeneratorResourceProvider;
import chalk.tools.util.featuregen.OutcomePriorFeatureGenerator;
import chalk.tools.util.featuregen.PrefixFeatureGenerator;
import chalk.tools.util.featuregen.PreviousMapFeatureGenerator;
import chalk.tools.util.featuregen.SentenceFeatureGenerator;
import chalk.tools.util.featuregen.SuffixFeatureGenerator;
import chalk.tools.util.featuregen.TokenClassFeatureGenerator;
import chalk.tools.util.featuregen.TokenFeatureGenerator;
import chalk.tools.util.featuregen.TokenPatternFeatureGenerator;
import chalk.tools.util.featuregen.WindowFeatureGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeneratorFactory {
    private static Map<String, XmlFeatureGeneratorFactory> factories = new HashMap<String, XmlFeatureGeneratorFactory>();

    static AdaptiveFeatureGenerator createGenerator(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) throws InvalidFormatException {
        String string = element.getTagName();
        XmlFeatureGeneratorFactory xmlFeatureGeneratorFactory = factories.get(string);
        if (xmlFeatureGeneratorFactory == null) {
            throw new InvalidFormatException("Unexpected element: " + string);
        }
        return xmlFeatureGeneratorFactory.create(element, featureGeneratorResourceProvider);
    }

    public static AdaptiveFeatureGenerator create(InputStream inputStream, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) throws IOException, InvalidFormatException {
        Document document;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            throw new InvalidFormatException("Descriptor is not valid XML!", sAXException);
        }
        Element element = document.getDocumentElement();
        return GeneratorFactory.createGenerator(element, featureGeneratorResourceProvider);
    }

    static {
        AggregatedFeatureGeneratorFactory.register(factories);
        CachedFeatureGeneratorFactory.register(factories);
        CharacterNgramFeatureGeneratorFactory.register(factories);
        DefinitionFeatureGeneratorFactory.register(factories);
        DictionaryFeatureGeneratorFactory.register(factories);
        PreviousMapFeatureGeneratorFactory.register(factories);
        SentenceFeatureGeneratorFactory.register(factories);
        TokenClassFeatureGeneratorFactory.register(factories);
        TokenFeatureGeneratorFactory.register(factories);
        BigramNameFeatureGeneratorFactory.register(factories);
        TokenPatternFeatureGeneratorFactory.register(factories);
        PrefixFeatureGeneratorFactory.register(factories);
        SuffixFeatureGeneratorFactory.register(factories);
        WindowFeatureGeneratorFactory.register(factories);
        CustomFeatureGeneratorFactory.register(factories);
    }

    static class CustomFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        CustomFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) throws InvalidFormatException {
            String string = element.getAttribute("class");
            AdaptiveFeatureGenerator adaptiveFeatureGenerator = ExtensionLoader.instantiateExtension(AdaptiveFeatureGenerator.class, string);
            return adaptiveFeatureGenerator;
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("custom", new CustomFeatureGeneratorFactory());
        }
    }

    static class SuffixFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        SuffixFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) {
            return new SuffixFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("suffix", new SuffixFeatureGeneratorFactory());
        }
    }

    static class PrefixFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        PrefixFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) {
            return new PrefixFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("prefix", new PrefixFeatureGeneratorFactory());
        }
    }

    static class WindowFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        WindowFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) throws InvalidFormatException {
            int n;
            int n2;
            Object object;
            Element element2 = null;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                if (!(object instanceof Element)) continue;
                element2 = (Element)object;
                break;
            }
            if (element2 == null) {
                throw new InvalidFormatException("window feature generator must contain an aggregator element");
            }
            AdaptiveFeatureGenerator adaptiveFeatureGenerator = GeneratorFactory.createGenerator(element2, featureGeneratorResourceProvider);
            object = element.getAttribute("prevLength");
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFormatException("prevLength attribute '" + (String)object + "' is not a number!", numberFormatException);
            }
            String string = element.getAttribute("nextLength");
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFormatException("nextLength attribute '" + string + "' is not a number!", numberFormatException);
            }
            return new WindowFeatureGenerator(adaptiveFeatureGenerator, n2, n);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("window", new WindowFeatureGeneratorFactory());
        }
    }

    static class TokenPatternFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        TokenPatternFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) {
            return new TokenPatternFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("tokenpattern", new TokenPatternFeatureGeneratorFactory());
        }
    }

    static class BigramNameFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        BigramNameFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) {
            return new BigramNameFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("bigram", new BigramNameFeatureGeneratorFactory());
        }
    }

    static class TokenFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        TokenFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) {
            return new TokenFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("token", new TokenFeatureGeneratorFactory());
        }
    }

    static class TokenClassFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        TokenClassFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) {
            return new TokenClassFeatureGenerator(true);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("tokenclass", new TokenClassFeatureGeneratorFactory());
        }
    }

    static class SentenceFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        SentenceFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) {
            String string = element.getAttribute("begin");
            boolean bl = true;
            if (string.length() != 0) {
                bl = Boolean.parseBoolean(string);
            }
            String string2 = element.getAttribute("end");
            boolean bl2 = true;
            if (string2.length() != 0) {
                bl2 = Boolean.parseBoolean(string2);
            }
            return new SentenceFeatureGenerator(bl, bl2);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("sentence", new SentenceFeatureGeneratorFactory());
        }
    }

    static class PreviousMapFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        PreviousMapFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) {
            return new PreviousMapFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("prevmap", new PreviousMapFeatureGeneratorFactory());
        }
    }

    static class DictionaryFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        DictionaryFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) throws InvalidFormatException {
            String string = element.getAttribute("dict");
            Object object = featureGeneratorResourceProvider.getResource(string);
            if (!(object instanceof Dictionary)) {
                throw new InvalidFormatException("No dictionary resource for key: " + string);
            }
            String string2 = element.getAttribute("prefix");
            return new DictionaryFeatureGenerator(string2, (Dictionary)object);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("dictionary", new DictionaryFeatureGeneratorFactory());
        }
    }

    static class DefinitionFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        private static final String ELEMENT_NAME = "definition";

        private DefinitionFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) throws InvalidFormatException {
            return new OutcomePriorFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put(ELEMENT_NAME, new DefinitionFeatureGeneratorFactory());
        }
    }

    static class CharacterNgramFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        CharacterNgramFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) throws InvalidFormatException {
            int n;
            int n2;
            String string = element.getAttribute("min");
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFormatException("min attribute '" + string + "' is not a number!", numberFormatException);
            }
            String string2 = element.getAttribute("max");
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFormatException("max attribute '" + string2 + "' is not a number!", numberFormatException);
            }
            return new CharacterNgramFeatureGenerator(n2, n);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("charngram", new CharacterNgramFeatureGeneratorFactory());
        }
    }

    static class CachedFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        private CachedFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) throws InvalidFormatException {
            Element element2 = null;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                element2 = (Element)node;
                break;
            }
            if (element2 == null) {
                throw new InvalidFormatException("Could not find containing generator element!");
            }
            AdaptiveFeatureGenerator adaptiveFeatureGenerator = GeneratorFactory.createGenerator(element2, featureGeneratorResourceProvider);
            return new CachedFeatureGenerator(adaptiveFeatureGenerator);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("cache", new CachedFeatureGeneratorFactory());
        }
    }

    static class AggregatedFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        AggregatedFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element element, FeatureGeneratorResourceProvider featureGeneratorResourceProvider) throws InvalidFormatException {
            LinkedList<AdaptiveFeatureGenerator> linkedList = new LinkedList<AdaptiveFeatureGenerator>();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element2 = (Element)node;
                linkedList.add(GeneratorFactory.createGenerator(element2, featureGeneratorResourceProvider));
            }
            return new AggregatedFeatureGenerator(linkedList.toArray(new AdaptiveFeatureGenerator[linkedList.size()]));
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> map) {
            map.put("generators", new AggregatedFeatureGeneratorFactory());
        }
    }

    static interface XmlFeatureGeneratorFactory {
        public AdaptiveFeatureGenerator create(Element var1, FeatureGeneratorResourceProvider var2) throws InvalidFormatException;
    }
}

