/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.featuregen;

import chalk.tools.tokenize.SimpleTokenizer;
import chalk.tools.tokenize.Tokenizer;
import chalk.tools.util.featuregen.FeatureGeneratorAdapter;
import chalk.tools.util.featuregen.FeatureGeneratorUtil;
import java.util.List;
import java.util.regex.Pattern;

public class TokenPatternFeatureGenerator
extends FeatureGeneratorAdapter {
    private Pattern noLetters = Pattern.compile("[^a-zA-Z]");
    private Tokenizer tokenizer;

    public TokenPatternFeatureGenerator() {
        this(SimpleTokenizer.INSTANCE);
    }

    public TokenPatternFeatureGenerator(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public void createFeatures(List<String> list, String[] stringArray, int n, String[] stringArray2) {
        String[] stringArray3 = this.tokenizer.tokenize(stringArray[n]);
        if (stringArray3.length == 1) {
            list.add("st=" + stringArray[n].toLowerCase());
            return;
        }
        list.add("stn=" + stringArray3.length);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray3.length; ++i) {
            if (i < stringArray3.length - 1) {
                list.add("pt2=" + FeatureGeneratorUtil.tokenFeature(stringArray3[i]) + FeatureGeneratorUtil.tokenFeature(stringArray3[i + 1]));
            }
            if (i < stringArray3.length - 2) {
                list.add("pt3=" + FeatureGeneratorUtil.tokenFeature(stringArray3[i]) + FeatureGeneratorUtil.tokenFeature(stringArray3[i + 1]) + FeatureGeneratorUtil.tokenFeature(stringArray3[i + 2]));
            }
            stringBuilder.append(FeatureGeneratorUtil.tokenFeature(stringArray3[i]));
            if (this.noLetters.matcher(stringArray3[i]).find()) continue;
            list.add("st=" + stringArray3[i].toLowerCase());
        }
        list.add("pta=" + stringBuilder.toString());
    }
}

