/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.featuregen;

import chalk.tools.util.featuregen.AdaptiveFeatureGenerator;
import chalk.tools.util.featuregen.AggregatedFeatureGenerator;
import java.util.ArrayList;
import java.util.List;

public class WindowFeatureGenerator
implements AdaptiveFeatureGenerator {
    public static final String PREV_PREFIX = "p";
    public static final String NEXT_PREFIX = "n";
    private final AdaptiveFeatureGenerator generator;
    private final int prevWindowSize;
    private final int nextWindowSize;

    public WindowFeatureGenerator(AdaptiveFeatureGenerator adaptiveFeatureGenerator, int n, int n2) {
        this.generator = adaptiveFeatureGenerator;
        this.prevWindowSize = n;
        this.nextWindowSize = n2;
    }

    public WindowFeatureGenerator(int n, int n2, AdaptiveFeatureGenerator ... adaptiveFeatureGeneratorArray) {
        this((AdaptiveFeatureGenerator)new AggregatedFeatureGenerator(adaptiveFeatureGeneratorArray), n, n2);
    }

    public WindowFeatureGenerator(AdaptiveFeatureGenerator adaptiveFeatureGenerator) {
        this(adaptiveFeatureGenerator, 5, 5);
    }

    public WindowFeatureGenerator(AdaptiveFeatureGenerator ... adaptiveFeatureGeneratorArray) {
        this((AdaptiveFeatureGenerator)new AggregatedFeatureGenerator(adaptiveFeatureGeneratorArray), 5, 5);
    }

    @Override
    public void createFeatures(List<String> list, String[] stringArray, int n, String[] stringArray2) {
        ArrayList<String> arrayList;
        int n2;
        this.generator.createFeatures(list, stringArray, n, stringArray2);
        for (n2 = 1; n2 < this.prevWindowSize + 1; ++n2) {
            if (n - n2 < 0) continue;
            arrayList = new ArrayList<String>();
            this.generator.createFeatures(arrayList, stringArray, n - n2, stringArray2);
            for (String string : arrayList) {
                list.add(PREV_PREFIX + n2 + string);
            }
        }
        for (n2 = 1; n2 < this.nextWindowSize + 1; ++n2) {
            if (n2 + n >= stringArray.length) continue;
            arrayList = new ArrayList();
            this.generator.createFeatures(arrayList, stringArray, n + n2, stringArray2);
            for (String string : arrayList) {
                list.add(NEXT_PREFIX + n2 + string);
            }
        }
    }

    @Override
    public void updateAdaptiveData(String[] stringArray, String[] stringArray2) {
        this.generator.updateAdaptiveData(stringArray, stringArray2);
    }

    @Override
    public void clearAdaptiveData() {
        this.generator.clearAdaptiveData();
    }

    public String toString() {
        return super.toString() + ": Prev window size: " + this.prevWindowSize + ", Next window size: " + this.nextWindowSize;
    }
}

