/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.util.model;

import chalk.tools.util.TrainingParameters;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import nak.model.AbstractModel;
import nak.model.GenericModelWriter;
import nak.model.MaxentModel;

public final class ModelUtil {
    private ModelUtil() {
    }

    public static void writeModel(AbstractModel abstractModel, final OutputStream outputStream) throws IOException {
        if (abstractModel == null) {
            throw new IllegalArgumentException("model parameter must not be null!");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("out parameter must not be null!");
        }
        GenericModelWriter genericModelWriter = new GenericModelWriter(abstractModel, new DataOutputStream(new OutputStream(){

            @Override
            public void write(int n) throws IOException {
                outputStream.write(n);
            }
        }));
        genericModelWriter.persist();
    }

    public static boolean validateOutcomes(MaxentModel maxentModel, String ... stringArray) {
        boolean bl = true;
        if (stringArray.length == maxentModel.getNumOutcomes()) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(Arrays.asList(stringArray));
            for (int i = 0; i < maxentModel.getNumOutcomes(); ++i) {
                if (hashSet.contains(maxentModel.getOutcome(i))) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void addCutoffAndIterations(Map<String, String> map, int n, int n2) {
        map.put("Training-Cutoff", Integer.toString(n));
        map.put("Training-Iterations", Integer.toString(n2));
    }

    public static TrainingParameters createTrainingParameters(int n, int n2) {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("Algorithm", "MAXENT");
        trainingParameters.put("Iterations", Integer.toString(n));
        trainingParameters.put("Cutoff", Integer.toString(n2));
        return trainingParameters;
    }
}

