/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.chunker;

import chalk.tools.chunker.ChunkerME;
import chalk.tools.chunker.ChunkerModel;
import chalk.uima.chunker.ChunkerModelResource;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public final class Chunker
extends CasAnnotator_ImplBase {
    public static final String CHUNK_TYPE_PARAMETER = "opennlp.uima.ChunkType";
    public static final String CHUNK_TAG_FEATURE_PARAMETER = "opennlp.uima.ChunkTagFeature";
    private Type mTokenType;
    private Type mChunkType;
    private Feature mPosFeature;
    private ChunkerME mChunker;
    private UimaContext context;
    private Logger mLogger;
    private Feature mChunkFeature;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        ChunkerModel chunkerModel;
        super.initialize(uimaContext);
        this.context = uimaContext;
        this.mLogger = uimaContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Chunker annotator.");
        }
        try {
            ChunkerModelResource chunkerModelResource = (ChunkerModelResource)uimaContext.getResourceObject(UimaUtil.MODEL_PARAMETER);
            chunkerModel = chunkerModelResource.getModel();
        }
        catch (ResourceAccessException resourceAccessException) {
            throw new ResourceInitializationException((Throwable)resourceAccessException);
        }
        this.mChunker = new ChunkerME(chunkerModel);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mChunkType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, CHUNK_TYPE_PARAMETER);
        this.mChunkFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mChunkType, CHUNK_TAG_FEATURE_PARAMETER, "uima.cas.String");
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
        this.mPosFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mTokenType, "opennlp.uima.POSFeature", "uima.cas.String");
    }

    private void addChunkAnnotation(CAS cAS, AnnotationFS[] annotationFSArray, String string, int n, int n2) {
        AnnotationFS annotationFS = cAS.createAnnotation(this.mChunkType, annotationFSArray[n].getBegin(), annotationFSArray[n2 - 1].getEnd());
        annotationFS.setStringValue(this.mChunkFeature, string);
        cAS.getIndexRepository().addFS((FeatureStructure)annotationFS);
    }

    public void process(CAS cAS) {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mTokenType);
        String[] stringArray = new String[annotationIndex.size()];
        String[] stringArray2 = new String[annotationIndex.size()];
        AnnotationFS[] annotationFSArray = new AnnotationFS[annotationIndex.size()];
        int n = 0;
        String[] stringArray3 = annotationIndex.iterator();
        while (stringArray3.hasNext()) {
            AnnotationFS annotationFS;
            annotationFSArray[n] = annotationFS = (AnnotationFS)stringArray3.next();
            stringArray[n] = annotationFS.getCoveredText();
            stringArray2[n++] = annotationFS.getFeatureValueAsString(this.mPosFeature);
        }
        stringArray3 = this.mChunker.chunk(stringArray, stringArray2);
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < stringArray3.length; ++i) {
            String string = stringArray3[i];
            if (string.startsWith("B")) {
                if (n2 != -1) {
                    this.addChunkAnnotation(cAS, annotationFSArray, stringArray3[i - 1].substring(2), n2, n3);
                }
                n2 = i;
                n3 = i + 1;
                continue;
            }
            if (string.startsWith("I")) {
                n3 = i + 1;
                continue;
            }
            if (string.startsWith("O")) {
                if (n2 == -1) continue;
                this.addChunkAnnotation(cAS, annotationFSArray, stringArray3[i - 1].substring(2), n2, n3);
                n2 = -1;
                n3 = -1;
                continue;
            }
            System.out.println("Unexpected tag: " + stringArray3[i]);
        }
        if (n2 != -1) {
            this.addChunkAnnotation(cAS, annotationFSArray, stringArray3[stringArray3.length - 1].substring(2), n2, n3);
        }
    }

    public void destroy() {
        this.mChunker = null;
    }
}

