/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.doccat;

import chalk.tools.doccat.DoccatModel;
import chalk.tools.doccat.DocumentCategorizer;
import chalk.tools.doccat.DocumentCategorizerME;
import chalk.uima.doccat.DoccatModelResource;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

abstract class AbstractDocumentCategorizer
extends CasAnnotator_ImplBase {
    private UimaContext context;
    private Logger mLogger;
    private DocumentCategorizer mCategorizer;
    private Type mTokenType;

    AbstractDocumentCategorizer() {
    }

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        DoccatModel doccatModel;
        super.initialize(uimaContext);
        this.context = uimaContext;
        this.mLogger = uimaContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Categorizer.");
        }
        try {
            DoccatModelResource doccatModelResource = (DoccatModelResource)uimaContext.getResourceObject(UimaUtil.MODEL_PARAMETER);
            doccatModel = doccatModelResource.getModel();
        }
        catch (ResourceAccessException resourceAccessException) {
            throw new ResourceInitializationException((Throwable)resourceAccessException);
        }
        this.mCategorizer = new DocumentCategorizerME(doccatModel);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
    }

    protected abstract void setBestCategory(CAS var1, String var2);

    public void process(CAS cAS) {
        double[] dArray = this.mTokenType != null ? this.mCategorizer.categorize(cAS.getDocumentText()) : this.mCategorizer.categorize(cAS.getDocumentText());
        String string = this.mCategorizer.getBestCategory(dArray);
        this.setBestCategory(cAS, string);
    }
}

