/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.doccat;

import chalk.tools.doccat.DoccatModel;
import chalk.tools.doccat.DocumentCategorizerME;
import chalk.tools.doccat.DocumentSample;
import chalk.tools.util.ObjectStreamUtils;
import chalk.uima.util.CasConsumerUtil;
import chalk.uima.util.OpennlpUtil;
import chalk.uima.util.UimaUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nak.maxent.GIS;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public class DocumentCategorizerTrainer
extends CasConsumer_ImplBase {
    private UimaContext mContext;
    private Logger mLogger;
    private String mModelName;
    private List<DocumentSample> documentSamples = new ArrayList<DocumentSample>();
    private Type mTokenType;
    private Type mCategoryType;
    private Feature mCategoryFeature;
    private String language;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        this.mContext = this.getUimaContext();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Doccat Trainer.");
        }
        this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
        this.language = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.Language");
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String string = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mTokenType = CasConsumerUtil.getType(typeSystem, string);
        String string2 = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.doccat.CategoryType");
        this.mCategoryType = CasConsumerUtil.getType(typeSystem, string2);
        String string3 = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.doccat.CategoryFeature");
        this.mCategoryFeature = this.mCategoryType.getFeatureByBaseName(string3);
    }

    public void processCas(CAS cAS) throws ResourceProcessException {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mCategoryType);
        if (annotationIndex.size() > 0) {
            AnnotationFS annotationFS = (AnnotationFS)annotationIndex.iterator().next();
            DocumentSample documentSample = new DocumentSample(annotationFS.getStringValue(this.mCategoryFeature), cAS.getDocumentText());
            this.documentSamples.add(documentSample);
        }
    }

    public void collectionProcessComplete(ProcessTrace processTrace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        DoccatModel doccatModel = DocumentCategorizerME.train(this.language, ObjectStreamUtils.createObjectStream(this.documentSamples));
        File file = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize(doccatModel, file);
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.documentSamples = null;
    }
}

