/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.namefind;

import chalk.tools.namefind.NameFinderME;
import chalk.tools.namefind.TokenNameFinderModel;
import chalk.tools.util.Span;
import chalk.tools.util.eval.Mean;
import chalk.uima.namefind.AbstractNameFinder;
import chalk.uima.namefind.TokenNameFinderModelResource;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.UimaUtil;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public final class NameFinder
extends AbstractNameFinder {
    public static final String NAME_TYPE_PARAMETER = "opennlp.uima.NameType";
    public static final String TOKEN_PATTERN_OPTIMIZATION = "opennlp.uima.TokenPatternOptimization";
    public static final String TOKEN_FEATURE_PARAMETER = "opennlp.uima.namefinder.TokenFeature";
    public static final String TOKEN_FEATURE_PREV_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenFeature.previousWindowSize";
    public static final String TOKEN_FEATURE_NEXT_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenFeature.nextWindowSize";
    public static final String TOKEN_CLASS_FEATURE_PARAMETER = "opennlp.uima.namefinder.TokenClassFeature";
    public static final String TOKEN_CLASS_FEATURE_PREV_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenClassFeature.previousWindowSize";
    public static final String TOKEN_CLASS_FEATURE_NEXT_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenClassFeature.nextWindowSize";
    private NameFinderME mNameFinder;
    private Feature probabilityFeature;
    private Type documentConfidenceType;
    private Feature documentConfidenceNameTypeFeature;
    private Feature documentConfidenceFeature;
    private Mean documentConfidence = new Mean();

    public NameFinder() {
        super("OpenNLP Maxent Name annotator");
    }

    @Override
    public void initialize() throws ResourceInitializationException {
        TokenNameFinderModel tokenNameFinderModel;
        Object object;
        super.initialize();
        try {
            object = (TokenNameFinderModelResource)this.context.getResourceObject(UimaUtil.MODEL_PARAMETER);
            tokenNameFinderModel = object.getModel();
        }
        catch (ResourceAccessException resourceAccessException) {
            throw new ResourceInitializationException((Throwable)resourceAccessException);
        }
        object = AnnotatorUtil.getOptionalIntegerParameter(this.context, "opennlp.uima.BeamSize");
        if (object == null) {
            object = 3;
        }
        this.mNameFinder = new NameFinderME(tokenNameFinderModel, (Integer)object);
    }

    @Override
    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.probabilityFeature = AnnotatorUtil.getOptionalFeatureParameter(this.context, this.mNameType, "opennlp.uima.ProbabilityFeature", "uima.cas.Double");
        this.documentConfidenceType = AnnotatorUtil.getOptionalTypeParameter(this.context, typeSystem, "opennlp.uima.DocumentConfidenceType");
        if (this.documentConfidenceType != null) {
            this.documentConfidenceNameTypeFeature = AnnotatorUtil.getRequiredFeature(this.documentConfidenceType, "nameType");
            this.documentConfidenceFeature = AnnotatorUtil.getRequiredFeature(this.documentConfidenceType, "confidence");
        }
    }

    @Override
    protected Span[] find(CAS cAS, String[] stringArray) {
        double[] dArray;
        Span[] spanArray = this.mNameFinder.find(stringArray);
        for (double d : dArray = this.mNameFinder.probs()) {
            this.documentConfidence.add(d);
        }
        return spanArray;
    }

    @Override
    protected void postProcessAnnotations(Span[] spanArray, AnnotationFS[] annotationFSArray) {
        if (this.probabilityFeature != null) {
            double[] dArray = this.mNameFinder.probs(spanArray);
            for (int i = 0; i < annotationFSArray.length; ++i) {
                annotationFSArray[i].setDoubleValue(this.probabilityFeature, dArray[i]);
            }
        }
    }

    @Override
    protected void documentDone(CAS cAS) {
        if (this.documentConfidenceType != null) {
            FeatureStructure featureStructure = cAS.createFS(this.documentConfidenceType);
            featureStructure.setDoubleValue(this.documentConfidenceFeature, this.documentConfidence.mean());
            featureStructure.setStringValue(this.documentConfidenceNameTypeFeature, this.mNameType.getName());
            cAS.addFsToIndexes(featureStructure);
        }
        this.mNameFinder.clearAdaptiveData();
        this.documentConfidence = new Mean();
    }

    public void destroy() {
        this.mNameFinder = null;
    }
}

