/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.namefind;

import chalk.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import chalk.tools.namefind.NameFinderME;
import chalk.tools.namefind.NameSample;
import chalk.tools.namefind.NameSampleDataStream;
import chalk.tools.namefind.TokenNameFinderModel;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.ObjectStreamUtils;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import chalk.tools.util.TrainingParameters;
import chalk.uima.util.CasConsumerUtil;
import chalk.uima.util.ContainingConstraint;
import chalk.uima.util.OpennlpUtil;
import chalk.uima.util.SampleTraceStream;
import chalk.uima.util.UimaUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nak.maxent.GIS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public final class NameFinderTrainer
extends CasConsumer_ImplBase {
    private static final String FEATURE_GENERATOR_DEFINITION_FILE_PARAMETER = "opennlp.uima.FeatureGeneratorFile";
    private static final String FEATURE_GENERATOR_RESOURCES_PARAMETER = "opennlp.uima.FeatureGeneratorResources";
    private Logger logger;
    private String modelPath;
    private byte[] featureGeneratorDefinition;
    private File featureGeneratorResourceDir;
    private String additionalTrainingDataFile;
    private String additionalTrainingDataEncoding;
    private File sampleTraceFile = null;
    private String sampleTraceFileEncoding = null;
    private Type sentenceType;
    private Type tokenType;
    private Type nameType;
    private String language;
    private List<NameSample> nameFinderSamples = new ArrayList<NameSample>();
    private TrainingParameters trainingParams;

    public void initialize() throws ResourceInitializationException {
        String string;
        super.initialize();
        this.logger = this.getUimaContext().getLogger();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Initializing the OpenNLP Name Trainer.");
        }
        this.modelPath = CasConsumerUtil.getRequiredStringParameter(this.getUimaContext(), UimaUtil.MODEL_PARAMETER);
        this.language = CasConsumerUtil.getRequiredStringParameter(this.getUimaContext(), "opennlp.uima.Language");
        this.trainingParams = OpennlpUtil.loadTrainingParams(CasConsumerUtil.getOptionalStringParameter(this.getUimaContext(), "opennlp.uima.TrainingParamsFile"), true);
        String string2 = CasConsumerUtil.getOptionalStringParameter(this.getUimaContext(), FEATURE_GENERATOR_DEFINITION_FILE_PARAMETER);
        if (string2 != null) {
            try {
                this.featureGeneratorDefinition = OpennlpUtil.loadBytes(new File(string2));
            }
            catch (IOException iOException) {
                throw new ResourceInitializationException((Throwable)iOException);
            }
            string = CasConsumerUtil.getOptionalStringParameter(this.getUimaContext(), FEATURE_GENERATOR_RESOURCES_PARAMETER);
            if (string != null) {
                this.featureGeneratorResourceDir = new File(string);
            }
        }
        this.additionalTrainingDataFile = CasConsumerUtil.getOptionalStringParameter(this.getUimaContext(), "opennlp.uima.AdditionalTrainingDataFile");
        if (this.additionalTrainingDataFile != null) {
            this.additionalTrainingDataEncoding = CasConsumerUtil.getRequiredStringParameter(this.getUimaContext(), "opennlp.uima.AdditionalTrainingDataEncoding");
        }
        if ((string = CasConsumerUtil.getOptionalStringParameter(this.getUimaContext(), "opennlp.uima.SampleTraceFile")) != null) {
            this.sampleTraceFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + string);
            this.sampleTraceFileEncoding = CasConsumerUtil.getRequiredStringParameter(this.getUimaContext(), "opennlp.uima.SampleTraceFileEncoding");
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String string = CasConsumerUtil.getRequiredStringParameter(this.getUimaContext(), UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.sentenceType = CasConsumerUtil.getType(typeSystem, string);
        String string2 = CasConsumerUtil.getRequiredStringParameter(this.getUimaContext(), "opennlp.uima.TokenType");
        this.tokenType = CasConsumerUtil.getType(typeSystem, string2);
        String string3 = CasConsumerUtil.getRequiredStringParameter(this.getUimaContext(), "opennlp.uima.NameType");
        this.nameType = CasConsumerUtil.getType(typeSystem, string3);
    }

    private static <T> List<T> iteratorToList(Iterator<T> iterator) {
        LinkedList<T> linkedList = new LinkedList<T>();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        return linkedList;
    }

    private static boolean isContaining(AnnotationFS annotationFS, AnnotationFS annotationFS2) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = annotationFS.getBegin() <= annotationFS2.getBegin();
        if (!bl2) {
            return false;
        }
        boolean bl4 = bl = annotationFS.getEnd() >= annotationFS2.getEnd();
        return bl;
    }

    private static Span[] createNames(List<AnnotationFS> list, List<AnnotationFS> list2) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        AnnotationFS annotationFS = null;
        int n = -1;
        int n2 = 0;
        for (AnnotationFS annotationFS2 : list) {
            for (AnnotationFS annotationFS3 : list2) {
                if (!NameFinderTrainer.isContaining(annotationFS3, annotationFS2)) {
                    if (annotationFS != annotationFS3) continue;
                    linkedList.add(new Span(n, n2));
                    n = -1;
                    annotationFS = null;
                }
                if (annotationFS != null || !NameFinderTrainer.isContaining(annotationFS3, annotationFS2)) continue;
                n = n2;
                annotationFS = annotationFS3;
            }
            ++n2;
        }
        if (annotationFS != null) {
            Span span = new Span(n, n2);
            linkedList.add(span);
        }
        return linkedList.toArray(new Span[linkedList.size()]);
    }

    public void processCas(CAS cAS) {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.sentenceType);
        boolean bl = true;
        for (AnnotationFS annotationFS : annotationIndex) {
            ContainingConstraint containingConstraint = new ContainingConstraint(annotationFS);
            AnnotationIndex annotationIndex2 = cAS.getAnnotationIndex(this.tokenType);
            FSIterator fSIterator = cAS.createFilteredIterator(annotationIndex2.iterator(), (FSMatchConstraint)containingConstraint);
            AnnotationIndex annotationIndex3 = cAS.getAnnotationIndex(this.nameType);
            FSIterator fSIterator2 = cAS.createFilteredIterator(annotationIndex3.iterator(), (FSMatchConstraint)containingConstraint);
            List<AnnotationFS> list = NameFinderTrainer.iteratorToList(fSIterator);
            Span[] spanArray = NameFinderTrainer.createNames(list, NameFinderTrainer.iteratorToList(fSIterator2));
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = list.get(i).getCoveredText();
            }
            NameSample nameSample = new NameSample(stringArray, spanArray, null, bl);
            if (nameSample.getSentence().length != 0) {
                this.nameFinderSamples.add(nameSample);
                if (!bl) continue;
                bl = false;
                continue;
            }
            if (!this.logger.isLoggable(Level.INFO)) continue;
            this.logger.log(Level.INFO, "Sentence without tokens: " + annotationFS.getCoveredText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectionProcessComplete(ProcessTrace processTrace) throws ResourceProcessException, IOException {
        TokenNameFinderModel tokenNameFinderModel;
        Map<String, Object> map;
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Collected " + this.nameFinderSamples.size() + " name samples.");
        }
        GIS.PRINT_MESSAGES = false;
        ObjectStream<NameSample> objectStream = ObjectStreamUtils.createObjectStream(this.nameFinderSamples);
        InputStream inputStream = null;
        Writer writer = null;
        try {
            if (this.additionalTrainingDataFile != null) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Using additional training data file: " + this.additionalTrainingDataFile);
                }
                inputStream = new FileInputStream(this.additionalTrainingDataFile);
                map = new NameSampleDataStream(new PlainTextByLineStream(new InputStreamReader(inputStream, this.additionalTrainingDataEncoding)));
                objectStream = ObjectStreamUtils.createObjectStream(new ObjectStream[]{objectStream, map});
            }
            if (this.sampleTraceFile != null) {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.sampleTraceFile), this.sampleTraceFileEncoding);
                objectStream = new SampleTraceStream<NameSample>(objectStream, writer);
            }
            map = this.featureGeneratorResourceDir != null ? TokenNameFinderTrainerTool.loadResources(this.featureGeneratorResourceDir) : Collections.emptyMap();
            tokenNameFinderModel = NameFinderME.train(this.language, null, objectStream, this.trainingParams, this.featureGeneratorDefinition, map);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        this.nameFinderSamples = null;
        map = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.modelPath);
        OpennlpUtil.serialize(tokenNameFinderModel, (File)((Object)map));
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Model was written to: " + ((File)((Object)map)).getAbsolutePath());
        }
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.nameFinderSamples = null;
    }
}

