/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.normalizer;

import chalk.tools.util.StringList;
import chalk.uima.normalizer.NumberUtil;
import chalk.uima.normalizer.StringDictionary;
import chalk.uima.util.AnnotatorUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class Normalizer
extends CasAnnotator_ImplBase {
    private static final Set<String> SUPPORTED_TYPES;
    private UimaContext context;
    private Logger mLogger;
    private Type mNameType;
    private Feature mStructureFeature;
    private StringDictionary mLookupDictionary;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        this.context = uimaContext;
        this.mLogger = uimaContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Normalizer annotator.");
        }
        try {
            String string = AnnotatorUtil.getOptionalStringParameter(uimaContext, "opennlp.uima.Dictionary");
            if (string != null) {
                InputStream inputStream = AnnotatorUtil.getResourceAsStream(uimaContext, string);
                this.mLookupDictionary = new StringDictionary(inputStream);
            }
        }
        catch (IOException iOException) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "io_error_model_reading", new Object[]{iOException.getMessage()}, (Throwable)iOException);
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mNameType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.NameType");
        this.mStructureFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mNameType, "opennlp.uima.normalizer.StructureFeature");
        if (!SUPPORTED_TYPES.contains(this.mStructureFeature.getRange().getName())) {
            throw new AnalysisEngineProcessException("opennlp.uima.util.ExceptionMessages", "range_type_unsupported", new Object[]{this.mStructureFeature.getRange().getName()});
        }
    }

    public void process(CAS cAS) {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mNameType);
        for (AnnotationFS annotationFS : annotationIndex) {
            Object object;
            String string;
            String string2 = cAS.getDocumentLanguage();
            if (!NumberUtil.isLanguageSupported(string2)) {
                if (!this.mLogger.isLoggable(Level.INFO)) continue;
                this.mLogger.log(Level.INFO, "Unsupported language: " + string2);
                continue;
            }
            String string3 = annotationFS.getCoveredText();
            if (this.mLookupDictionary != null && (string = this.mLookupDictionary.get((StringList)(object = new StringList(string3)))) != null) {
                string3 = string;
            }
            if ("uima.cas.String".equals(this.mStructureFeature.getRange().getName())) {
                annotationFS.setStringValue(this.mStructureFeature, string3);
                continue;
            }
            try {
                object = NumberUtil.parse(string3, string2);
            }
            catch (ParseException parseException) {
                if (!this.mLogger.isLoggable(Level.INFO)) continue;
                this.mLogger.log(Level.INFO, "Invalid number format: " + string3);
                continue;
            }
            if ("uima.cas.Byte".equals(this.mStructureFeature.getRange().getName())) {
                annotationFS.setByteValue(this.mStructureFeature, ((Number)object).byteValue());
                continue;
            }
            if ("uima.cas.Short".equals(this.mStructureFeature.getRange().getName())) {
                annotationFS.setShortValue(this.mStructureFeature, ((Number)object).shortValue());
                continue;
            }
            if ("uima.cas.Integer".equals(this.mStructureFeature.getRange().getName())) {
                annotationFS.setIntValue(this.mStructureFeature, ((Number)object).intValue());
                continue;
            }
            if ("uima.cas.Long".equals(this.mStructureFeature.getRange().getName())) {
                annotationFS.setLongValue(this.mStructureFeature, ((Number)object).longValue());
                continue;
            }
            if ("uima.cas.Float".equals(this.mStructureFeature.getRange().getName())) {
                annotationFS.setFloatValue(this.mStructureFeature, ((Number)object).floatValue());
                continue;
            }
            if (!"uima.cas.Double".equals(this.mStructureFeature.getRange().getName())) continue;
            annotationFS.setDoubleValue(this.mStructureFeature, ((Number)object).doubleValue());
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("uima.cas.String");
        hashSet.add("uima.cas.Byte");
        hashSet.add("uima.cas.Short");
        hashSet.add("uima.cas.Integer");
        hashSet.add("uima.cas.Long");
        hashSet.add("uima.cas.Float");
        hashSet.add("uima.cas.Double");
        SUPPORTED_TYPES = Collections.unmodifiableSet(hashSet);
    }
}

