/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.normalizer;

import chalk.tools.dictionary.serializer.Attributes;
import chalk.tools.dictionary.serializer.DictionarySerializer;
import chalk.tools.dictionary.serializer.Entry;
import chalk.tools.dictionary.serializer.EntryInserter;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.StringList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StringDictionary {
    private Map<StringList, String> entries = new HashMap<StringList, String>();

    public StringDictionary() {
    }

    public StringDictionary(InputStream inputStream) throws IOException, InvalidFormatException {
        DictionarySerializer.create(inputStream, new EntryInserter(){

            @Override
            public void insert(Entry entry) throws InvalidFormatException {
                String string = entry.getAttributes().getValue("value");
                StringDictionary.this.put(entry.getTokens(), string);
            }
        });
    }

    public String get(StringList stringList) {
        return this.entries.get(stringList);
    }

    public void put(StringList stringList, String string) {
        this.entries.put(stringList, string);
    }

    Iterator<StringList> iterator() {
        return this.entries.keySet().iterator();
    }

    public void serialize(OutputStream outputStream) throws IOException {
        Iterator<Entry> iterator = new Iterator<Entry>(){
            private Iterator<StringList> mDictionaryIterator;
            {
                this.mDictionaryIterator = StringDictionary.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mDictionaryIterator.hasNext();
            }

            @Override
            public Entry next() {
                StringList stringList = this.mDictionaryIterator.next();
                Attributes attributes = new Attributes();
                attributes.setValue("value", StringDictionary.this.get(stringList));
                return new Entry(stringList, attributes);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(outputStream, iterator, true);
    }
}

