/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.parser;

import chalk.tools.parser.Parse;
import chalk.tools.parser.ParserFactory;
import chalk.tools.parser.ParserModel;
import chalk.tools.util.Span;
import chalk.uima.parser.ParserModelResource;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.ContainingConstraint;
import chalk.uima.util.UimaUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class Parser
extends CasAnnotator_ImplBase {
    public static final String PARSE_TYPE_PARAMETER = "opennlp.uima.ParseType";
    public static final String TYPE_FEATURE_PARAMETER = "opennlp.uima.TypeFeature";
    public static final String CHILDREN_FEATURE_PARAMETER = "opennlp.uima.ChildrenFeature";
    public static final String PROBABILITY_FEATURE_PARAMETER = "opennlp.uima.ProbabilityFeature";
    protected UimaContext context;
    protected Logger mLogger;
    private Type mSentenceType;
    private Type mTokenType;
    protected chalk.tools.parser.Parser mParser;
    private Type mParseType;
    private Feature mTypeFeature;
    private Feature childrenFeature;
    private Feature probabilityFeature;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        ParserModel parserModel;
        super.initialize(uimaContext);
        this.context = uimaContext;
        this.mLogger = uimaContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Parser.");
        }
        try {
            ParserModelResource parserModelResource = (ParserModelResource)uimaContext.getResourceObject(UimaUtil.MODEL_PARAMETER);
            parserModel = parserModelResource.getModel();
        }
        catch (ResourceAccessException resourceAccessException) {
            throw new ResourceInitializationException((Throwable)resourceAccessException);
        }
        this.mParser = ParserFactory.create(parserModel);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mSentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
        this.mParseType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, PARSE_TYPE_PARAMETER);
        this.mTypeFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mParseType, TYPE_FEATURE_PARAMETER, "uima.cas.String");
        this.childrenFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mParseType, CHILDREN_FEATURE_PARAMETER, "uima.cas.FSArray");
        this.probabilityFeature = AnnotatorUtil.getOptionalFeatureParameter(this.context, this.mParseType, PROBABILITY_FEATURE_PARAMETER, "uima.cas.Double");
    }

    public void process(CAS cAS) {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS annotationFS : annotationIndex) {
            this.process(cAS, annotationFS);
        }
    }

    protected void process(CAS cAS, AnnotationFS annotationFS) {
        Object object;
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mTokenType);
        ContainingConstraint containingConstraint = new ContainingConstraint(annotationFS);
        String string = annotationFS.getCoveredText();
        FSIterator fSIterator = cAS.createFilteredIterator(annotationIndex.iterator(), (FSMatchConstraint)containingConstraint);
        LinkedList<Span> linkedList = new LinkedList<Span>();
        while (fSIterator.hasNext()) {
            object = (AnnotationFS)fSIterator.next();
            linkedList.add(new Span(object.getBegin() - annotationFS.getBegin(), object.getEnd() - annotationFS.getBegin()));
        }
        object = new ParseConverter(string, linkedList.toArray(new Span[linkedList.size()]));
        Parse parse = ((ParseConverter)object).getParseForTagger();
        if (parse.getChildCount() > 0) {
            Parse parse2 = this.mParser.parse(parse);
            parse2 = ((ParseConverter)object).transformParseFromTagger(parse2);
            if (this.mLogger.isLoggable(Level.INFO)) {
                StringBuffer stringBuffer = new StringBuffer();
                parse2.show(stringBuffer);
                this.mLogger.log(Level.INFO, stringBuffer.toString());
            }
            this.createAnnotation(cAS, annotationFS.getBegin(), parse2);
        }
    }

    protected AnnotationFS createAnnotation(CAS cAS, int n, Parse parse) {
        Parse[] parseArray = parse.getChildren();
        AnnotationFS[] annotationFSArray = new AnnotationFS[parseArray.length];
        for (int i = 0; i < parseArray.length; ++i) {
            annotationFSArray[i] = this.createAnnotation(cAS, n, parseArray[i]);
        }
        AnnotationFS annotationFS = cAS.createAnnotation(this.mParseType, n + parse.getSpan().getStart(), n + parse.getSpan().getEnd());
        annotationFS.setStringValue(this.mTypeFeature, parse.getType());
        if (this.probabilityFeature != null) {
            annotationFS.setDoubleValue(this.probabilityFeature, parse.getProb());
        }
        ArrayFS arrayFS = cAS.createArrayFS(annotationFSArray.length);
        arrayFS.copyFromArray((FeatureStructure[])annotationFSArray, 0, 0, annotationFSArray.length);
        annotationFS.setFeatureValue(this.childrenFeature, (FeatureStructure)arrayFS);
        cAS.getIndexRepository().addFS((FeatureStructure)annotationFS);
        return annotationFS;
    }

    public void destroy() {
        this.mParser = null;
    }

    private static class ParseConverter {
        private Map<Integer, Integer> mIndexMap = new HashMap<Integer, Integer>();
        private Parse mParseForTagger;
        private final String mSentence;

        public ParseConverter(String string, Span[] spanArray) {
            this.mSentence = string;
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = new String[spanArray.length];
            for (int i = 0; i < spanArray.length; ++i) {
                String string2 = ((Object)spanArray[i].getCoveredText(string)).toString();
                String[] stringArray2 = ParseConverter.escape(string2);
                stringArray[i] = stringArray2;
                int n = stringBuilder.length();
                int n2 = spanArray[i].getStart();
                this.mIndexMap.put(n, n2);
                int n3 = n + stringArray2.length();
                int n4 = spanArray[i].getEnd();
                this.mIndexMap.put(n3, n4);
                stringBuilder.append(stringArray[i]);
                stringBuilder.append(' ');
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            String string3 = stringBuilder.toString();
            this.mParseForTagger = new Parse(string3, new Span(0, string3.length()), "INC", 1.0, null);
            int n = 0;
            for (String string4 : stringArray) {
                this.mParseForTagger.insert(new Parse(string3, new Span(n, n + string4.length()), "TK", 0.0, 0));
                n += string4.length() + 1;
            }
        }

        private static String escape(String string) {
            return string;
        }

        Parse getParseForTagger() {
            return this.mParseForTagger;
        }

        Parse transformParseFromTagger(Parse parse) {
            Parse[] parseArray;
            int n = parse.getSpan().getStart();
            int n2 = parse.getSpan().getEnd();
            Parse parse2 = new Parse(this.mSentence, new Span(this.mIndexMap.get(n), (int)this.mIndexMap.get(n2)), parse.getType(), parse.getProb(), parse.getHeadIndex());
            for (Parse parse3 : parseArray = parse.getChildren()) {
                parse2.insert(this.transformParseFromTagger(parse3));
            }
            return parse2;
        }
    }
}

