/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.postag;

import chalk.tools.postag.POSDictionary;
import chalk.tools.postag.POSModel;
import chalk.tools.postag.POSSample;
import chalk.tools.postag.POSTaggerME;
import chalk.tools.util.ObjectStreamUtils;
import chalk.tools.util.model.ModelType;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.CasConsumerUtil;
import chalk.uima.util.ContainingConstraint;
import chalk.uima.util.OpennlpUtil;
import chalk.uima.util.UimaUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import nak.maxent.GIS;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public class POSTaggerTrainer
extends CasConsumer_ImplBase {
    public static final String TAG_DICTIONARY_NAME = "opennlp.uima.TagDictionaryName";
    private UimaContext mContext;
    private Type mSentenceType;
    private Type mTokenType;
    private String mModelName;
    private Feature mPOSFeature;
    private Logger mLogger;
    private List<POSSample> mPOSSamples = new ArrayList<POSSample>();
    private String language;
    private POSDictionary tagDictionary;

    public void initialize() throws ResourceInitializationException {
        block4: {
            super.initialize();
            this.mContext = this.getUimaContext();
            this.mLogger = this.mContext.getLogger();
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, "Initializing the OpenNLP POSTagger trainer.");
            }
            this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
            this.language = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.Language");
            String string = CasConsumerUtil.getOptionalStringParameter(this.mContext, TAG_DICTIONARY_NAME);
            if (string != null) {
                try {
                    InputStream inputStream = AnnotatorUtil.getResourceAsStream(this.mContext, string);
                    this.tagDictionary = new POSDictionary(new BufferedReader(new InputStreamReader(inputStream)), false);
                }
                catch (IOException iOException) {
                    String string2 = "IOException during tag dictionary reading, running without tag dictionary: " + iOException.getMessage();
                    if (!this.mLogger.isLoggable(Level.WARNING)) break block4;
                    this.mLogger.log(Level.WARNING, string2);
                }
            }
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String string = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, UimaUtil.SENTENCE_TYPE_PARAMETER + ": " + string);
        }
        this.mSentenceType = CasConsumerUtil.getType(typeSystem, string);
        String string2 = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.TokenType");
        this.mTokenType = CasConsumerUtil.getType(typeSystem, string2);
        String string3 = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.POSFeature");
        this.mPOSFeature = this.mTokenType.getFeatureByBaseName(string3);
    }

    public void processCas(CAS cAS) {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS annotationFS : annotationIndex) {
            this.process(cAS, annotationFS);
        }
    }

    private void process(CAS cAS, AnnotationFS annotationFS) {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mTokenType);
        ContainingConstraint containingConstraint = new ContainingConstraint(annotationFS);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        FSIterator fSIterator = cAS.createFilteredIterator(annotationIndex.iterator(), (FSMatchConstraint)containingConstraint);
        while (fSIterator.hasNext()) {
            AnnotationFS annotationFS2 = (AnnotationFS)fSIterator.next();
            String string = annotationFS2.getFeatureValueAsString(this.mPOSFeature);
            arrayList.add(annotationFS2.getCoveredText().trim());
            arrayList2.add(string);
        }
        this.mPOSSamples.add(new POSSample(arrayList, arrayList2));
    }

    public void collectionProcessComplete(ProcessTrace processTrace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        POSModel pOSModel = POSTaggerME.train(this.language, ObjectStreamUtils.createObjectStream(this.mPOSSamples), ModelType.MAXENT, this.tagDictionary, null, 100, 5);
        this.mPOSSamples = null;
        File file = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize(pOSModel, file);
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.mPOSSamples = null;
    }
}

