/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.sentdetect;

import chalk.tools.sentdetect.SentenceDetectorME;
import chalk.tools.sentdetect.SentenceModel;
import chalk.tools.util.Span;
import chalk.uima.sentdetect.AbstractSentenceDetector;
import chalk.uima.sentdetect.SentenceModelResource;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public final class SentenceDetector
extends AbstractSentenceDetector {
    private SentenceDetectorME sentenceDetector;
    private Feature probabilityFeature;

    @Override
    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        SentenceModel sentenceModel;
        super.initialize(uimaContext);
        try {
            SentenceModelResource sentenceModelResource = (SentenceModelResource)uimaContext.getResourceObject(UimaUtil.MODEL_PARAMETER);
            sentenceModel = sentenceModelResource.getModel();
        }
        catch (ResourceAccessException resourceAccessException) {
            throw new ResourceInitializationException((Throwable)resourceAccessException);
        }
        this.sentenceDetector = new SentenceDetectorME(sentenceModel);
    }

    @Override
    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.probabilityFeature = AnnotatorUtil.getOptionalFeatureParameter(this.context, this.sentenceType, "opennlp.uima.ProbabilityFeature", "uima.cas.Double");
    }

    @Override
    protected Span[] detectSentences(String string) {
        return this.sentenceDetector.sentPosDetect(string);
    }

    @Override
    protected void postProcessAnnotations(AnnotationFS[] annotationFSArray) {
        if (this.probabilityFeature != null) {
            double[] dArray = this.sentenceDetector.getSentenceProbabilities();
            for (int i = 0; i < annotationFSArray.length; ++i) {
                annotationFSArray[i].setDoubleValue(this.probabilityFeature, dArray[i]);
            }
        }
    }

    public void destroy() {
        this.sentenceDetector = null;
    }
}

