/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.tokenize;

import chalk.tools.util.Span;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public abstract class AbstractTokenizer
extends CasAnnotator_ImplBase {
    protected final String name;
    protected UimaContext context;
    protected Logger logger;
    protected Type sentenceType;
    protected Type tokenType;
    private Boolean isRemoveExistingAnnotations;

    protected AbstractTokenizer(String string) {
        this.name = string;
    }

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        this.context = uimaContext;
        this.logger = uimaContext.getLogger();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Initializing the " + this.name + " annotator.");
        }
        this.isRemoveExistingAnnotations = AnnotatorUtil.getOptionalBooleanParameter(uimaContext, "opennlp.uima.IsRemoveExistingAnnotations");
        if (this.isRemoveExistingAnnotations == null) {
            this.isRemoveExistingAnnotations = false;
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.sentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.tokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
    }

    protected void postProcessAnnotations(Span[] spanArray, AnnotationFS[] annotationFSArray) {
    }

    protected abstract Span[] tokenize(CAS var1, AnnotationFS var2);

    public void process(CAS cAS) throws AnalysisEngineProcessException {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.sentenceType);
        for (AnnotationFS annotationFS : annotationIndex) {
            if (this.isRemoveExistingAnnotations.booleanValue()) {
                UimaUtil.removeAnnotations(cAS, annotationFS, this.tokenType);
            }
            Span[] spanArray = this.tokenize(cAS, annotationFS);
            int n = annotationFS.getBegin();
            StringBuilder stringBuilder = new StringBuilder();
            AnnotationFS[] annotationFSArray = new AnnotationFS[spanArray.length];
            for (int i = 0; i < spanArray.length; ++i) {
                annotationFSArray[i] = cAS.createAnnotation(this.tokenType, n + spanArray[i].getStart(), n + spanArray[i].getEnd());
                cAS.getIndexRepository().addFS((FeatureStructure)annotationFSArray[i]);
                if (!this.logger.isLoggable(Level.FINER)) continue;
                stringBuilder.append(annotationFSArray[i].getCoveredText());
                stringBuilder.append(' ');
            }
            if (this.logger.isLoggable(Level.FINER)) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length() - 1);
                this.logger.log(Level.FINER, "\"" + stringBuilder.toString() + "\"");
            }
            this.postProcessAnnotations(spanArray, annotationFSArray);
        }
    }
}

