/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.tokenize;

import chalk.tools.tokenize.TokenizerME;
import chalk.tools.tokenize.TokenizerModel;
import chalk.tools.util.Span;
import chalk.uima.tokenize.AbstractTokenizer;
import chalk.uima.tokenize.TokenizerModelResource;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public final class Tokenizer
extends AbstractTokenizer {
    private TokenizerME tokenizer;
    private Feature probabilityFeature;

    public Tokenizer() {
        super("OpenNLP Tokenizer");
    }

    @Override
    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        TokenizerModel tokenizerModel;
        super.initialize(uimaContext);
        try {
            TokenizerModelResource tokenizerModelResource = (TokenizerModelResource)uimaContext.getResourceObject(UimaUtil.MODEL_PARAMETER);
            tokenizerModel = tokenizerModelResource.getModel();
        }
        catch (ResourceAccessException resourceAccessException) {
            throw new ResourceInitializationException((Throwable)resourceAccessException);
        }
        this.tokenizer = new TokenizerME(tokenizerModel);
    }

    @Override
    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.probabilityFeature = AnnotatorUtil.getOptionalFeatureParameter(this.context, this.tokenType, "opennlp.uima.ProbabilityFeature", "uima.cas.Double");
    }

    @Override
    protected Span[] tokenize(CAS cAS, AnnotationFS annotationFS) {
        return this.tokenizer.tokenizePos(annotationFS.getCoveredText());
    }

    @Override
    protected void postProcessAnnotations(Span[] spanArray, AnnotationFS[] annotationFSArray) {
        if (this.probabilityFeature != null) {
            double[] dArray = this.tokenizer.getTokenProbabilities();
            for (int i = 0; i < annotationFSArray.length; ++i) {
                annotationFSArray[i].setDoubleValue(this.probabilityFeature, dArray[i]);
            }
        }
    }

    public void destroy() {
        this.tokenizer = null;
    }
}

