/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.util;

import chalk.uima.util.AnnotationIteratorPair;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;

public class AnnotationComboIterator
implements Iterable<AnnotationIteratorPair>,
Iterator<AnnotationIteratorPair> {
    private final FSIterator<AnnotationFS> upperIt;
    private final FSIterator<AnnotationFS> lowerIt;
    private int upperBegin;
    private int upperEnd;
    private boolean nextLowerChecked = false;
    private boolean nextLowerAvailable = false;

    public AnnotationComboIterator(CAS cAS, Type type, Type type2) {
        this.upperIt = cAS.getAnnotationIndex(type).iterator();
        this.lowerIt = cAS.getAnnotationIndex(type2).iterator();
        this.upperIt.moveToFirst();
        this.lowerIt.moveToFirst();
        if (this.upperIt.isValid()) {
            AnnotationFS annotationFS = (AnnotationFS)this.upperIt.get();
            this.upperBegin = annotationFS.getBegin();
            this.upperEnd = annotationFS.getEnd();
        } else {
            this.nextLowerChecked = true;
        }
    }

    @Override
    public boolean hasNext() {
        return this.upperIt.hasNext();
    }

    @Override
    public AnnotationIteratorPair next() {
        if (!this.upperIt.hasNext()) {
            throw new NoSuchElementException();
        }
        AnnotationFS annotationFS = (AnnotationFS)this.upperIt.next();
        this.upperBegin = annotationFS.getBegin();
        this.upperEnd = annotationFS.getEnd();
        this.nextLowerChecked = false;
        return new AnnotationIteratorPair(annotationFS, new AnnotationIterator());
    }

    @Override
    public Iterator<AnnotationIteratorPair> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class AnnotationIterator
    implements Iterable<AnnotationFS>,
    Iterator<AnnotationFS> {
        private AnnotationIterator() {
        }

        public AnnotationIterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (AnnotationComboIterator.this.nextLowerChecked) {
                return AnnotationComboIterator.this.nextLowerAvailable;
            }
            AnnotationComboIterator.this.nextLowerChecked = true;
            AnnotationComboIterator.this.nextLowerAvailable = false;
            if (AnnotationComboIterator.this.lowerIt.isValid()) {
                AnnotationFS annotationFS = (AnnotationFS)AnnotationComboIterator.this.lowerIt.get();
                int n = annotationFS.getBegin();
                while (n < AnnotationComboIterator.this.upperBegin) {
                    AnnotationComboIterator.this.lowerIt.moveToNext();
                    if (AnnotationComboIterator.this.lowerIt.isValid()) {
                        annotationFS = (AnnotationFS)AnnotationComboIterator.this.lowerIt.next();
                        n = annotationFS.getBegin();
                        continue;
                    }
                    return false;
                }
                if (AnnotationComboIterator.this.upperEnd >= annotationFS.getEnd()) {
                    AnnotationComboIterator.this.nextLowerAvailable = true;
                }
            }
            return AnnotationComboIterator.this.nextLowerAvailable;
        }

        @Override
        public AnnotationFS next() {
            if (AnnotationComboIterator.this.nextLowerChecked ? !AnnotationComboIterator.this.nextLowerAvailable : !this.hasNext()) {
                throw new NoSuchElementException();
            }
            AnnotationComboIterator.this.nextLowerChecked = false;
            AnnotationFS annotationFS = (AnnotationFS)AnnotationComboIterator.this.lowerIt.get();
            AnnotationComboIterator.this.lowerIt.moveToNext();
            return annotationFS;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

