/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.util;

import chalk.tools.dictionary.Dictionary;
import java.io.IOException;
import java.io.InputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public final class CasConsumerUtil {
    private CasConsumerUtil() {
    }

    public static InputStream getOptionalResourceAsStream(UimaContext uimaContext, String string) throws ResourceInitializationException {
        try {
            return uimaContext.getResourceAsStream(string);
        }
        catch (ResourceAccessException resourceAccessException) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"There is an internal error in the UIMA SDK: " + resourceAccessException.getMessage(), resourceAccessException});
        }
    }

    public static InputStream getResourceAsStream(UimaContext uimaContext, String string) throws ResourceInitializationException {
        InputStream inputStream = CasConsumerUtil.getOptionalResourceAsStream(uimaContext, string);
        if (inputStream == null) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"Unable to load resource!"});
        }
        return inputStream;
    }

    public static Type getType(TypeSystem typeSystem, String string) throws ResourceInitializationException {
        Type type = CasConsumerUtil.getOptionalType(typeSystem, string);
        if (type == null) {
            throw new ResourceInitializationException("incompatible_range_types", new Object[]{"Unable to retrieve " + string + " type!"});
        }
        return type;
    }

    public static Type getOptionalType(TypeSystem typeSystem, String string) throws ResourceInitializationException {
        return typeSystem.getType(string);
    }

    public static String getRequiredStringParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        String string2 = CasConsumerUtil.getOptionalStringParameter(uimaContext, string);
        CasConsumerUtil.checkForNull(string2, string);
        return string2;
    }

    public static Integer getRequiredIntegerParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Integer n = CasConsumerUtil.getOptionalIntegerParameter(uimaContext, string);
        CasConsumerUtil.checkForNull(n, string);
        return n;
    }

    public static Float getRequiredFloatParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Float f = CasConsumerUtil.getOptionalFloatParameter(uimaContext, string);
        CasConsumerUtil.checkForNull(f, string);
        return f;
    }

    public static Boolean getRequiredBooleanParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Boolean bl = CasConsumerUtil.getOptionalBooleanParameter(uimaContext, string);
        CasConsumerUtil.checkForNull(bl, string);
        return bl;
    }

    private static void checkForNull(Object object, String string) throws ResourceInitializationException {
        if (object == null) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The " + string + " is a " + "required parameter!"});
        }
    }

    public static String getOptionalStringParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = CasConsumerUtil.getOptionalParameter(uimaContext, string);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + string + " does not have" + " the expected type String"});
    }

    public static String[] getOptionalStringArrayParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = CasConsumerUtil.getOptionalParameter(uimaContext, string);
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object == null) {
            return new String[0];
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + string + " does not have the expected type String array"});
    }

    public static Integer getOptionalIntegerParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = CasConsumerUtil.getOptionalParameter(uimaContext, string);
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + string + " does not have " + "the expected type Integer"});
    }

    public static Integer getOptionalIntegerParameter(UimaContext uimaContext, String string, int n) throws ResourceInitializationException {
        Integer n2 = CasConsumerUtil.getOptionalIntegerParameter(uimaContext, string);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    public static Float getOptionalFloatParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = CasConsumerUtil.getOptionalParameter(uimaContext, string);
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + string + " does not have" + " the expected type Float"});
    }

    public static Boolean getOptionalBooleanParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = CasConsumerUtil.getOptionalParameter(uimaContext, string);
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + string + " does not have" + " the expected type Boolean"});
    }

    private static Object getOptionalParameter(UimaContext uimaContext, String string) {
        Object object = uimaContext.getConfigParameterValue(string);
        Logger logger = uimaContext.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, string + " = " + (object != null ? object.toString() : "not set"));
        }
        return object;
    }

    public static void checkFeatureType(Feature feature, String string) throws ResourceInitializationException {
        if (!feature.getRange().getName().equals(string)) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The Feature " + feature.getName() + " must be of type " + string + " !"});
        }
    }

    public static Dictionary createOptionalDictionary(UimaContext uimaContext, String string) throws ResourceInitializationException {
        String string2 = CasConsumerUtil.getOptionalStringParameter(uimaContext, string);
        Dictionary dictionary = null;
        if (string2 != null) {
            block5: {
                Logger logger = uimaContext.getLogger();
                try {
                    InputStream inputStream = CasConsumerUtil.getOptionalResourceAsStream(uimaContext, string2);
                    if (inputStream == null) {
                        String string3 = "The dictionary file " + string2 + " does not exist!";
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, string3);
                        }
                        return null;
                    }
                    dictionary = new Dictionary(inputStream);
                }
                catch (IOException iOException) {
                    String string4 = "IOException during dictionary reading, running without dictionary: " + iOException.getMessage();
                    if (!logger.isLoggable(Level.WARNING)) break block5;
                    logger.log(Level.WARNING, string4);
                }
            }
            return dictionary;
        }
        return null;
    }
}

