/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.chunker;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.chunker.ChunkerEvaluationMonitor;
import chalk.tools.chunker.ChunkerEvaluator;
import chalk.tools.chunker.ChunkerFactory;
import chalk.tools.chunker.ChunkerME;
import chalk.tools.chunker.ChunkerModel;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.eval.CrossValidationPartitioner;
import chalk.tools.util.eval.FMeasure;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;

public class ChunkerCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private FMeasure fmeasure = new FMeasure();
    private ChunkerEvaluationMonitor[] listeners;
    private ChunkerFactory chunkerFactory;

    @Deprecated
    public ChunkerCrossValidator(String string, int n, int n2) {
        this.languageCode = string;
        this.params = ModelUtil.createTrainingParameters(n2, n);
        this.listeners = null;
    }

    public ChunkerCrossValidator(String string, TrainingParameters trainingParameters, ChunkerEvaluationMonitor ... chunkerEvaluationMonitorArray) {
        this.languageCode = string;
        this.params = trainingParameters;
        this.listeners = chunkerEvaluationMonitorArray;
    }

    public ChunkerCrossValidator(String string, TrainingParameters trainingParameters, ChunkerFactory chunkerFactory, ChunkerEvaluationMonitor ... chunkerEvaluationMonitorArray) {
        this.chunkerFactory = chunkerFactory;
        this.languageCode = string;
        this.params = trainingParameters;
        this.listeners = chunkerEvaluationMonitorArray;
    }

    public void evaluate(ObjectStream<ChunkSample> objectStream, int n) throws IOException, InvalidFormatException, IOException {
        CrossValidationPartitioner<ChunkSample> crossValidationPartitioner = new CrossValidationPartitioner<ChunkSample>(objectStream, n);
        while (crossValidationPartitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<ChunkSample> trainingSampleStream = crossValidationPartitioner.next();
            ChunkerModel chunkerModel = ChunkerME.train(this.languageCode, trainingSampleStream, this.params, this.chunkerFactory);
            ChunkerEvaluator chunkerEvaluator = new ChunkerEvaluator(new ChunkerME(chunkerModel, 10), this.listeners);
            chunkerEvaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(chunkerEvaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

