/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.chunker;

import chalk.tools.chunker.ChunkerFactory;
import chalk.tools.util.BaseToolFactory;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.model.BaseModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import nak.core.LinearModel;
import nak.data.DataReader;
import nak.io.BinaryFileDataReader;
import nak.io.GenericModelReader;

public class ChunkerModel
extends BaseModel {
    private static final String COMPONENT_NAME = "ChunkerME";
    private static final String CHUNKER_MODEL_ENTRY_NAME = "chunker.model";

    public ChunkerModel(String string, LinearModel linearModel, Map<String, String> map) {
        this(string, linearModel, map, new ChunkerFactory());
    }

    public ChunkerModel(String string, LinearModel linearModel, Map<String, String> map, ChunkerFactory chunkerFactory) {
        super(COMPONENT_NAME, string, map, chunkerFactory);
        this.artifactMap.put(CHUNKER_MODEL_ENTRY_NAME, linearModel);
        this.checkArtifactMap();
    }

    public ChunkerModel(String string, LinearModel linearModel) {
        this(string, linearModel, null, new ChunkerFactory());
    }

    public ChunkerModel(String string, LinearModel linearModel, ChunkerFactory chunkerFactory) {
        this(string, linearModel, null, chunkerFactory);
    }

    public ChunkerModel(InputStream inputStream) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, inputStream);
    }

    public ChunkerModel(File file) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, file);
    }

    public ChunkerModel(URL uRL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, uRL);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME) instanceof LinearModel)) {
            throw new InvalidFormatException("Chunker model is incomplete!");
        }
    }

    public LinearModel getChunkerModel() {
        return (LinearModel)this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME);
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return ChunkerFactory.class;
    }

    public ChunkerFactory getFactory() {
        return (ChunkerFactory)this.toolFactory;
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException {
        if (stringArray.length != 4) {
            System.err.println("ChunkerModel -lang code packageName modelName");
            System.exit(1);
        }
        String string = stringArray[1];
        String string2 = stringArray[2];
        String string3 = stringArray[3];
        LinearModel linearModel = new GenericModelReader((DataReader)new BinaryFileDataReader((InputStream)new FileInputStream(string3))).getModel();
        ChunkerModel chunkerModel = new ChunkerModel(string, linearModel);
        chunkerModel.serialize(new FileOutputStream(string2));
    }
}

