/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline;

import chalk.tools.cmdline.AbstractTypedTool;
import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.ObjectStreamFactory;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.util.ObjectStream;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractConverterTool<T>
extends AbstractTypedTool<T> {
    protected AbstractConverterTool(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public String getShortDescription() {
        Map map = StreamFactoryRegistry.getFactories(this.type);
        StringBuilder stringBuilder = new StringBuilder();
        if (2 == map.keySet().size()) {
            for (String string : map.keySet()) {
                if ("opennlp".equals(string)) continue;
                stringBuilder.append(string);
            }
            return "converts " + stringBuilder.toString() + " data format to native OpenNLP format";
        }
        if (2 < map.keySet().size()) {
            for (String string : map.keySet()) {
                if ("opennlp".equals(string)) continue;
                stringBuilder.append(string).append(",");
            }
            return "converts foreign data formats (" + stringBuilder.substring(0, stringBuilder.length() - 1) + ") to native OpenNLP format";
        }
        throw new AssertionError((Object)"There should be more than 1 factory registered for converter tool");
    }

    private String createHelpString(String string, String string2) {
        return "Usage: chalk " + this.getName() + " " + string + " " + string2;
    }

    @Override
    public String getHelp() {
        Map map = StreamFactoryRegistry.getFactories(this.type);
        StringBuilder stringBuilder = new StringBuilder("help|");
        for (String string : map.keySet()) {
            if ("opennlp".equals(string)) continue;
            stringBuilder.append(string).append("|");
        }
        return this.createHelpString(stringBuilder.substring(0, stringBuilder.length() - 1), "[help|options...]");
    }

    @Override
    public String getHelp(String string) {
        return this.getHelp();
    }

    @Override
    public void run(String string, String[] stringArray) {
        if (0 == stringArray.length) {
            System.out.println(this.getHelp());
        } else {
            String string2;
            string = stringArray[0];
            ObjectStreamFactory objectStreamFactory = this.getStreamFactory(string);
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            String string3 = this.createHelpString(string, ArgumentParser.createUsage(objectStreamFactory.getParameters()));
            if (0 == stringArray2.length || 1 == stringArray2.length && "help".equals(stringArray2[0])) {
                System.out.println(string3);
                System.exit(0);
            }
            if (null != (string2 = ArgumentParser.validateArgumentsLoudly(stringArray2, objectStreamFactory.getParameters()))) {
                throw new TerminateToolException(1, string2 + "\n" + string3);
            }
            ObjectStream objectStream = objectStreamFactory.create(stringArray2);
            try {
                Object t;
                while ((t = objectStream.read()) != null) {
                    System.out.println(t.toString());
                }
            }
            catch (IOException iOException) {
                throw new TerminateToolException(-1, "IO error while converting data : " + iOException.getMessage(), iOException);
            }
            finally {
                if (objectStream != null) {
                    try {
                        objectStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

