/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline;

import chalk.tools.util.Span;
import chalk.tools.util.eval.EvaluationMonitor;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class EvaluationErrorPrinter<T>
implements EvaluationMonitor<T> {
    private PrintStream printStream;

    protected EvaluationErrorPrinter(OutputStream outputStream) {
        this.printStream = new PrintStream(outputStream);
    }

    protected void printError(Span[] spanArray, Span[] spanArray2, T t, T t2, String string) {
        ArrayList<Span> arrayList = new ArrayList<Span>();
        ArrayList<Span> arrayList2 = new ArrayList<Span>();
        this.findErrors(spanArray, spanArray2, arrayList, arrayList2);
        if (arrayList2.size() + arrayList.size() > 0) {
            this.printSamples(t, t2);
            this.printErrors(arrayList2, arrayList, string);
        }
    }

    protected void printError(Span[] spanArray, Span[] spanArray2, T t, T t2, String[] stringArray) {
        ArrayList<Span> arrayList = new ArrayList<Span>();
        ArrayList<Span> arrayList2 = new ArrayList<Span>();
        this.findErrors(spanArray, spanArray2, arrayList, arrayList2);
        if (arrayList2.size() + arrayList.size() > 0) {
            this.printSamples(t, t2);
            this.printErrors(arrayList2, arrayList, stringArray);
        }
    }

    protected void printError(String[] stringArray, String[] stringArray2, T t, T t2, String[] stringArray3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            arrayList.add(stringArray3[i]);
            arrayList2.add(stringArray[i]);
            arrayList3.add(stringArray2[i]);
        }
        if (arrayList.size() > 0) {
            this.printSamples(t, t2);
            this.printErrors(arrayList, arrayList2, arrayList3);
        }
    }

    private void printErrors(List<String> list, List<String> list2, List<String> list3) {
        this.printStream.println("Errors: {");
        this.printStream.println("Tok: Ref | Pred");
        this.printStream.println("---------------");
        for (int i = 0; i < list.size(); ++i) {
            this.printStream.println(list.get(i) + ": " + list2.get(i) + " | " + list3.get(i));
        }
        this.printStream.println("}\n");
    }

    private void printErrors(List<Span> list, List<Span> list2, String string) {
        this.printStream.println("False positives: {");
        for (Span span : list) {
            this.printStream.println(span.getCoveredText(string));
        }
        this.printStream.println("} False negatives: {");
        for (Span span : list2) {
            this.printStream.println(span.getCoveredText(string));
        }
        this.printStream.println("}\n");
    }

    private void printErrors(List<Span> list, List<Span> list2, String[] stringArray) {
        this.printStream.println("False positives: {");
        this.printStream.println(this.print(list, stringArray));
        this.printStream.println("} False negatives: {");
        this.printStream.println(this.print(list2, stringArray));
        this.printStream.println("}\n");
    }

    private String print(List<Span> list, String[] stringArray) {
        return Arrays.toString(Span.spansToStrings(list.toArray(new Span[list.size()]), stringArray));
    }

    private <S> void printSamples(S s, S s2) {
        String string = "Expected: {\n" + s + "}\nPredicted: {\n" + s2 + "}";
        this.printStream.println(string);
    }

    private void findErrors(Span[] spanArray, Span[] spanArray2, List<Span> list, List<Span> list2) {
        list.addAll(Arrays.asList(spanArray));
        list2.addAll(Arrays.asList(spanArray2));
        for (int i = 0; i < spanArray.length; ++i) {
            Span span = spanArray[i];
            for (int j = 0; j < spanArray2.length; ++j) {
                if (!span.equals(spanArray2[j])) continue;
                list.remove(span);
                list2.remove(spanArray2[j]);
            }
        }
    }

    @Override
    public void correctlyClassified(T t, T t2) {
    }

    @Override
    public abstract void missclassified(T var1, T var2);
}

